/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.client.rest.handler;

import io.americanexpress.synapse.client.rest.handler.BaseResponseErrorHandler;
import io.americanexpress.synapse.framework.exception.ApplicationClientException;
import io.americanexpress.synapse.framework.exception.model.ErrorCode;
import java.util.function.Function;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.reactive.function.client.ClientResponse;
import reactor.core.publisher.Mono;

public abstract class BaseReactiveRestResponseErrorHandler
extends BaseResponseErrorHandler
implements Function<ClientResponse, Mono<? extends Throwable>> {
    @Override
    public Mono<? extends Throwable> apply(ClientResponse clientResponse) {
        HttpStatusCode httpStatus = clientResponse.statusCode();
        return httpStatus.is4xxClientError() ? clientResponse.bodyToMono(String.class).map(errorMessage -> new ApplicationClientException(this.buildDeveloperMessage(httpStatus, (String)errorMessage), ErrorCode.GENERIC_4XX_ERROR, new String[0])) : clientResponse.bodyToMono(String.class).map(errorMessage -> {
            this.logger.error(errorMessage);
            return new ApplicationClientException(this.buildDeveloperMessage(httpStatus, (String)errorMessage), ErrorCode.GENERIC_5XX_ERROR, new String[0]);
        });
    }
}

