/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.client.rest.helper;

import io.americanexpress.synapse.client.rest.helper.RestClientLoggingInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.http.client.BufferingClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class RestClientLoggingCustomizer
implements RestTemplateCustomizer {
    private final RestClientLoggingInterceptor restClientLoggingInterceptor;

    @Autowired
    public RestClientLoggingCustomizer(RestClientLoggingInterceptor restClientLoggingInterceptor) {
        this.restClientLoggingInterceptor = restClientLoggingInterceptor;
    }

    public void customize(RestTemplate restTemplate) {
        restTemplate.setRequestFactory((ClientHttpRequestFactory)new BufferingClientHttpRequestFactory(restTemplate.getRequestFactory()));
        restTemplate.getInterceptors().add(this.restClientLoggingInterceptor);
    }
}

