/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.client.rest.config;

import io.americanexpress.synapse.client.rest.client.BaseRestClient;
import io.americanexpress.synapse.client.rest.config.BaseClientConfig;
import io.americanexpress.synapse.client.rest.handler.BaseRestResponseErrorHandler;
import io.americanexpress.synapse.client.rest.helper.RestClientLoggingCustomizer;
import java.util.ArrayList;
import java.util.Arrays;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.MediaType;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

@Configuration
@Import(value={BaseClientConfig.class})
public abstract class BaseRestClientConfig
extends BaseClientConfig {
    @Autowired
    protected RestClientLoggingCustomizer restClientLoggingCustomizer;

    protected void initializeClient(String destinationUrl, BaseRestClient restClient, BaseRestResponseErrorHandler restResponseErrorHandler) {
        restClient.setUrl(destinationUrl);
        RestTemplate restTemplate = this.defaultRestTemplate();
        restTemplate.setErrorHandler((ResponseErrorHandler)restResponseErrorHandler);
        restClient.setRestTemplate(restTemplate);
    }

    public RestTemplate defaultRestTemplate() {
        RestTemplate restTemplate = new RestTemplateBuilder(new RestTemplateCustomizer[0]).customizers(new RestTemplateCustomizer[]{this.restClientLoggingCustomizer}).build();
        ArrayList<MappingJackson2HttpMessageConverter> messagesConverters = new ArrayList<MappingJackson2HttpMessageConverter>();
        MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter(this.getObjectMapper());
        converter.setSupportedMediaTypes(Arrays.asList(MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML));
        messagesConverters.add(converter);
        restTemplate.setMessageConverters(messagesConverters);
        return restTemplate;
    }
}

