/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.client.rest.helper;

import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import reactor.core.publisher.Mono;

public class ReactiveRestClientLoggingExchangeFilterFunction {
    private static final XLogger logger = XLoggerFactory.getXLogger(ReactiveRestClientLoggingExchangeFilterFunction.class);

    private ReactiveRestClientLoggingExchangeFilterFunction() {
    }

    public static ExchangeFilterFunction logClientRequest() {
        return ExchangeFilterFunction.ofRequestProcessor(clientRequest -> {
            logger.info("Client Request: URI={}, HTTP Method={}, HTTP Headers={}", new Object[]{clientRequest.url(), clientRequest.method(), clientRequest.headers()});
            return Mono.just((Object)clientRequest);
        });
    }

    public static ExchangeFilterFunction logClientResponse() {
        return ExchangeFilterFunction.ofResponseProcessor(clientResponse -> {
            logger.info("Client Response: HTTP Status={}, HTTP Headers={}", (Object)clientResponse.statusCode(), (Object)clientResponse.headers());
            return Mono.just((Object)clientResponse);
        });
    }
}

