/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.client.rest.client;

import io.americanexpress.synapse.client.rest.client.BaseClient;
import io.americanexpress.synapse.client.rest.factory.BaseClientHttpHeadersFactory;
import io.americanexpress.synapse.client.rest.helper.UrlBuilder;
import io.americanexpress.synapse.client.rest.model.BaseClientRequest;
import io.americanexpress.synapse.client.rest.model.BaseClientResponse;
import io.americanexpress.synapse.client.rest.model.ClientHeaders;
import io.americanexpress.synapse.client.rest.model.QueryParameter;
import java.net.URI;
import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public abstract class BaseRestClient<I extends BaseClientRequest, O extends BaseClientResponse, H extends BaseClientHttpHeadersFactory<I>>
extends BaseClient<I, O, H> {
    protected RestTemplate restTemplate;

    protected BaseRestClient(H httpHeadersFactory, HttpMethod httpMethod) {
        super(httpHeadersFactory, httpMethod);
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public O callMonoService(ClientHeaders clientHeaders, I clientRequest, String ... pathVariables) {
        return this.callMonoService(clientHeaders, clientRequest, (List<QueryParameter>)null, pathVariables);
    }

    public O callMonoService(ClientHeaders clientHeaders, I clientRequest, List<QueryParameter> queryParameters, String ... pathVariables) {
        RequestEntity<I> requestEntity = this.createRequestEntity(clientHeaders, clientRequest, queryParameters, pathVariables);
        ResponseEntity responseEntity = this.restTemplate.exchange(requestEntity, this.clientResponseType);
        BaseClientResponse responseBody = (BaseClientResponse)responseEntity.getBody();
        return (O)responseBody;
    }

    public List<O> callPolyService(ClientHeaders clientHeaders, I clientRequest, ParameterizedTypeReference<List<O>> responseEntityType, String ... pathVariables) {
        return this.callPolyService(clientHeaders, clientRequest, responseEntityType, (List<QueryParameter>)null, pathVariables);
    }

    public List<O> callPolyService(ClientHeaders clientHeaders, I clientRequest, ParameterizedTypeReference<List<O>> responseEntityType, List<QueryParameter> queryParameters, String ... pathVariables) {
        RequestEntity<I> requestEntity = this.createRequestEntity(clientHeaders, clientRequest, queryParameters, pathVariables);
        ResponseEntity responseEntity = this.restTemplate.exchange(requestEntity, responseEntityType);
        return (List)responseEntity.getBody();
    }

    private RequestEntity<I> createRequestEntity(ClientHeaders clientHeaders, I clientRequest, List<QueryParameter> queryParameters, String ... pathVariables) {
        String updatedUrl = UrlBuilder.build(this.url, queryParameters, pathVariables);
        URI uri = URI.create(updatedUrl);
        HttpHeaders httpHeaders = this.httpHeadersFactory.create(clientHeaders, clientRequest, updatedUrl);
        return new RequestEntity(clientRequest, (MultiValueMap)httpHeaders, this.httpMethod, uri);
    }
}

