/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.synapse.client.rest.helper;

import io.americanexpress.synapse.client.rest.model.QueryParameter;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

final class QueryParameterUriCreator {
    private QueryParameterUriCreator() {
    }

    static String create(List<QueryParameter> queryParameters) {
        return Optional.ofNullable(queryParameters).filter(CollectionUtils::isNotEmpty).map(queryParameterElements -> {
            String formattedQueryParameters = queryParameterElements.stream().filter(queryParameterElement -> Objects.nonNull(queryParameterElement) && StringUtils.isNotBlank((CharSequence)queryParameterElement.getKey()) && StringUtils.isNotBlank((CharSequence)queryParameterElement.getValue())).map(QueryParameter::format).collect(Collectors.joining("&"));
            return StringUtils.isNotBlank((CharSequence)formattedQueryParameters) ? "?" + formattedQueryParameters : "";
        }).orElse("");
    }
}

