/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.service.book.rest.service;

import io.americanexpress.data.oracle.book.dao.BookRepository;
import io.americanexpress.data.oracle.book.entity.BookEntity;
import io.americanexpress.service.book.rest.model.UpdateBookRequest;
import io.americanexpress.service.book.rest.service.helper.BookServiceMapper;
import io.americanexpress.synapse.framework.exception.ApplicationClientException;
import io.americanexpress.synapse.framework.exception.model.ErrorCode;
import io.americanexpress.synapse.service.rest.service.BaseUpdateService;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Service;

@Service
public class UpdateBookService
extends BaseUpdateService<UpdateBookRequest> {
    private BookRepository bookRepository;

    public UpdateBookService(BookRepository bookRepository) {
        this.bookRepository = bookRepository;
    }

    protected void executeUpdate(HttpHeaders headers, UpdateBookRequest request) {
        BookEntity bookEntity = this.bookRepository.findByTitle(request.getTitle());
        if (bookEntity == null) {
            throw new ApplicationClientException("Bad request", ErrorCode.GENERIC_4XX_ERROR, (String[])null);
        }
        this.bookRepository.save((Object)BookServiceMapper.populateBookEntityForUpdate(request, bookEntity));
    }
}

