/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.service.book.rest.service;

import io.americanexpress.data.oracle.book.dao.BookRepository;
import io.americanexpress.data.oracle.book.entity.BookEntity;
import io.americanexpress.service.book.rest.model.CreateBookRequest;
import io.americanexpress.service.book.rest.model.CreateBookResponse;
import io.americanexpress.service.book.rest.service.helper.BookServiceMapper;
import io.americanexpress.synapse.framework.exception.ApplicationClientException;
import io.americanexpress.synapse.framework.exception.model.ErrorCode;
import io.americanexpress.synapse.service.rest.service.BaseCreateService;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Service;

@Service
public class CreateBookService
extends BaseCreateService<CreateBookRequest, CreateBookResponse> {
    private final BookRepository bookRepository;

    public CreateBookService(BookRepository bookRepository) {
        this.bookRepository = bookRepository;
    }

    protected CreateBookResponse executeCreate(HttpHeaders headers, CreateBookRequest request) {
        if (this.isTitlePresent(request.getTitle())) {
            BookEntity bookEntity = (BookEntity)this.bookRepository.save((Object)BookServiceMapper.populateBookEntityForCreation(request));
            return BookServiceMapper.populateCreateBookResponse(bookEntity);
        }
        throw new ApplicationClientException("Bad request", ErrorCode.GENERIC_4XX_ERROR, (String[])null);
    }

    private boolean isTitlePresent(String title) {
        return this.bookRepository.findByTitle(title) == null;
    }
}

