/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.service.book.rest.service;

import io.americanexpress.data.oracle.book.dao.BookRepository;
import io.americanexpress.data.oracle.book.entity.BookEntity;
import io.americanexpress.service.book.rest.model.ReadBookResponse;
import io.americanexpress.service.book.rest.service.helper.BookServiceMapper;
import io.americanexpress.synapse.framework.exception.ApplicationClientException;
import io.americanexpress.synapse.framework.exception.model.ErrorCode;
import io.americanexpress.synapse.service.rest.service.BaseGetMonoService;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Service;

@Service
public class GetBookService
extends BaseGetMonoService<ReadBookResponse> {
    private final BookRepository bookRepository;

    public GetBookService(BookRepository bookRepository) {
        this.bookRepository = bookRepository;
    }

    protected ReadBookResponse executeRead(HttpHeaders headers, String title) {
        BookEntity bookEntity = this.bookRepository.findByTitle(title);
        if (bookEntity == null) {
            throw new ApplicationClientException("Bad request", ErrorCode.GENERIC_4XX_ERROR, (String[])null);
        }
        return BookServiceMapper.populateReadBookResponse(bookEntity);
    }
}

