/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.service.book.rest.service;

import io.americanexpress.data.oracle.book.dao.BookRepository;
import io.americanexpress.service.book.rest.model.ReadBookResponse;
import io.americanexpress.service.book.rest.service.helper.BookServiceMapper;
import io.americanexpress.synapse.framework.exception.ApplicationClientException;
import io.americanexpress.synapse.framework.exception.model.ErrorCode;
import io.americanexpress.synapse.service.reactive.rest.service.BaseGetMonoReactiveService;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class GetBookService
extends BaseGetMonoReactiveService<ReadBookResponse> {
    private final BookRepository bookRepository;

    public GetBookService(BookRepository bookRepository) {
        this.bookRepository = bookRepository;
    }

    protected Mono<ReadBookResponse> executeRead(HttpHeaders headers, String title) {
        return this.bookRepository.findByTitle(title).map(BookServiceMapper::populateReadBookResponse).switchIfEmpty(Mono.error((Throwable)new ApplicationClientException("Bad request", ErrorCode.GENERIC_4XX_ERROR, (String[])null)));
    }
}

