/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.service.book.rest.service;

import io.americanexpress.data.mysql.book.dao.BookRepository;
import io.americanexpress.data.mysql.book.entity.BookEntity;
import io.americanexpress.service.book.rest.model.CreateBookRequest;
import io.americanexpress.service.book.rest.model.CreateBookResponse;
import io.americanexpress.service.book.rest.service.helper.BookServiceMapper;
import io.americanexpress.synapse.framework.exception.ApplicationClientException;
import io.americanexpress.synapse.framework.exception.model.ErrorCode;
import io.americanexpress.synapse.service.reactive.rest.service.BaseCreateReactiveService;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class CreateBookService
extends BaseCreateReactiveService<CreateBookRequest, CreateBookResponse> {
    private final BookRepository bookRepository;

    public CreateBookService(BookRepository bookRepository) {
        this.bookRepository = bookRepository;
    }

    protected Mono<CreateBookResponse> executeCreate(HttpHeaders headers, CreateBookRequest request) {
        return this.bookRepository.findByTitle(request.getTitle()).flatMap(entity -> entity != null ? Mono.error((Throwable)new ApplicationClientException("Duplicate record.", ErrorCode.GENERIC_4XX_ERROR, (String[])null)) : Mono.just((Object)new BookEntity())).switchIfEmpty(this.bookRepository.save((Object)BookServiceMapper.populateBookEntityForCreation(request))).map(BookServiceMapper::populateCreateBookResponse);
    }
}

