/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.service.book.rest.service;

import io.americanexpress.data.mysql.book.dao.BookRepository;
import io.americanexpress.synapse.framework.exception.ApplicationClientException;
import io.americanexpress.synapse.framework.exception.model.ErrorCode;
import io.americanexpress.synapse.service.reactive.rest.service.BaseDeleteReactiveService;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Service
public class DeleteBookService
extends BaseDeleteReactiveService {
    private final BookRepository bookRepository;

    public DeleteBookService(BookRepository bookRepository) {
        this.bookRepository = bookRepository;
    }

    protected Mono<Void> executeDelete(HttpHeaders headers, String title) {
        return this.bookRepository.findByTitle(title).publishOn(Schedulers.boundedElastic()).switchIfEmpty(Mono.error((Throwable)new ApplicationClientException("Not found.", ErrorCode.NOT_FOUND, (String[])null))).doOnSuccess(bookEntity -> this.bookRepository.deleteByTitle(bookEntity.getTitle()).subscribe()).then();
    }
}

