/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.service.book.rest.service;

import io.americanexpress.data.mysql.book.dao.BookRepository;
import io.americanexpress.service.book.rest.model.UpdateBookRequest;
import io.americanexpress.service.book.rest.service.helper.BookServiceMapper;
import io.americanexpress.synapse.framework.exception.ApplicationClientException;
import io.americanexpress.synapse.framework.exception.model.ErrorCode;
import io.americanexpress.synapse.service.rest.service.reactive.BaseUpdateReactiveService;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Service
public class UpdateBookService
extends BaseUpdateReactiveService<UpdateBookRequest> {
    private final BookRepository bookRepository;

    public UpdateBookService(BookRepository bookRepository) {
        this.bookRepository = bookRepository;
    }

    protected Mono<Void> executeUpdate(HttpHeaders headers, UpdateBookRequest request) {
        return this.bookRepository.findByTitleAndAuthor(request.getTitle(), request.getAuthor()).publishOn(Schedulers.boundedElastic()).switchIfEmpty(Mono.error((Throwable)new ApplicationClientException("Bad request", ErrorCode.NOT_FOUND, (String[])null))).doOnSuccess(bookEntity -> this.bookRepository.save((Object)BookServiceMapper.populateBookEntityForUpdate(request, bookEntity)).subscribe()).then();
    }
}

