/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.service.book.rest.service;

import io.americanexpress.data.book.entity.BookEntity;
import io.americanexpress.data.book.repository.BookRepository;
import io.americanexpress.service.book.rest.model.UpdateBookRequest;
import io.americanexpress.synapse.service.rest.service.reactive.BaseUpdateReactiveService;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;
import reactor.core.publisher.Mono;

@Service
public class UpdateBookReactiveService
extends BaseUpdateReactiveService<UpdateBookRequest> {
    private final BookRepository bookRepository;

    public UpdateBookReactiveService(BookRepository bookRepository) {
        this.bookRepository = bookRepository;
    }

    protected Mono<Void> executeUpdate(HttpHeaders headers, UpdateBookRequest request) {
        return this.bookRepository.findByTitleAndAuthor(request.getTitle(), request.getAuthor()).switchIfEmpty(Mono.error((Throwable)new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Book Not Found"))).map(book -> this.updateBook((BookEntity)book, request.getNumberOfCopies())).flatMap(arg_0 -> ((BookRepository)this.bookRepository).save(arg_0)).then();
    }

    private BookEntity updateBook(BookEntity book, int numOfCopies) {
        if (book != null) {
            book.setNumberOfCopies(numOfCopies);
        }
        return book;
    }
}

