/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.service.book.rest.service;

import io.americanexpress.data.book.repository.BookRepository;
import io.americanexpress.service.book.rest.model.ReadBookRequest;
import io.americanexpress.service.book.rest.model.ReadBookResponse;
import io.americanexpress.service.book.rest.service.helper.ReadBookResponseCreator;
import io.americanexpress.synapse.service.reactive.rest.service.BaseReadMonoReactiveService;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class ReadBookReactiveService
extends BaseReadMonoReactiveService<ReadBookRequest, ReadBookResponse> {
    private final BookRepository bookRepository;

    public ReadBookReactiveService(BookRepository bookRepository) {
        this.bookRepository = bookRepository;
    }

    protected Mono<ReadBookResponse> executeRead(HttpHeaders headers, ReadBookRequest request) {
        return this.bookRepository.findByTitleAndAuthor(request.getTitle(), request.getAuthor()).map(ReadBookResponseCreator::create).switchIfEmpty(Mono.empty());
    }
}

