/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.service.book.rest.service;

import io.americanexpress.data.book.entity.BookEntity;
import io.americanexpress.data.book.repository.BookRepository;
import io.americanexpress.service.book.rest.model.CreateBookRequest;
import io.americanexpress.service.book.rest.model.CreateBookResponse;
import io.americanexpress.service.book.rest.service.helper.BookEntityCreator;
import io.americanexpress.synapse.service.rest.service.reactive.BaseCreateReactiveService;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class CreateBookReactiveService
extends BaseCreateReactiveService<CreateBookRequest, CreateBookResponse> {
    private final BookRepository bookRepository;

    public CreateBookReactiveService(BookRepository bookRepository) {
        this.bookRepository = bookRepository;
    }

    protected Mono<CreateBookResponse> executeCreate(HttpHeaders headers, CreateBookRequest request) {
        BookEntity bookEntity = BookEntityCreator.create(request.getTitle(), request.getAuthor(), 1);
        return this.bookRepository.save((Object)bookEntity).map(book -> new CreateBookResponse()).switchIfEmpty(Mono.empty());
    }
}

