/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.service.book.graphql.resolver.query;

import graphql.kickstart.tools.GraphQLQueryResolver;
import graphql.relay.Connection;
import io.americanexpress.service.book.graphql.model.Book;
import io.americanexpress.service.book.graphql.service.BookService;
import io.americanexpress.synapse.service.graphql.model.Pageable;
import io.americanexpress.synapse.service.graphql.pagination.ConnectionUtil;
import io.americanexpress.synapse.service.graphql.pagination.UUIDUtil;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BookQueryResolver
implements GraphQLQueryResolver,
Pageable<Book> {
    private final BookService bookService;

    @Autowired
    public BookQueryResolver(BookService bookService) {
        this.bookService = bookService;
    }

    public List<Book> getBooks() {
        return this.bookService.getAll();
    }

    public Book getBook(UUID id) {
        return this.bookService.get(id);
    }

    public Connection<Book> getPaginatedElements(int first, String after) {
        List<Book> books = this.bookService.getAll();
        if (after != null && !after.isBlank()) {
            books = this.bookService.getAllAfter(UUIDUtil.toUUID((String)after));
        }
        return ConnectionUtil.create(books, (long)first, (String)after);
    }
}

