/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.service.book.graphql.resolver.mutation;

import graphql.kickstart.tools.GraphQLMutationResolver;
import io.americanexpress.service.book.graphql.model.Book;
import io.americanexpress.service.book.graphql.service.BookService;
import io.americanexpress.synapse.service.graphql.model.ReactiveResponseCreator;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BookReactiveMutationResolver
implements GraphQLMutationResolver {
    private final BookService bookService;

    @Autowired
    public BookReactiveMutationResolver(BookService bookService) {
        this.bookService = bookService;
    }

    public CompletableFuture<Book> createBookReactively(Book book) {
        return ReactiveResponseCreator.create((Object)this.bookService.create(book));
    }

    public CompletableFuture<Book> updateBookReactively(UUID id, Book book) {
        return ReactiveResponseCreator.create((Object)this.bookService.update(id, book));
    }

    public CompletableFuture<Book> deleteBookReactively(UUID id) {
        return ReactiveResponseCreator.create((Object)this.bookService.delete(id));
    }
}

