/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.service.book.graphql.service;

import io.americanexpress.service.book.graphql.model.Book;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class BookService {
    private static final List<Book> BOOKS = BookService.initialize();

    private static final List<Book> initialize() {
        ArrayList<Book> books = new ArrayList<Book>();
        books.add(new Book(UUID.fromString("c2ab9a0c-e5d8-4271-a377-a23250ee3a9e"), "Alice's Allegories", "Alice Doe"));
        books.add(new Book(UUID.fromString("d8fad5e7-d7d4-44ed-8758-2bad187a75ce"), "Bob's Biography", "Bob Doe"));
        books.add(new Book(UUID.fromString("2b0c31de-2258-442a-8b93-20f8358ff0a7"), "Catie's Comics", "Catie Doe"));
        books.add(new Book(UUID.fromString("36d779f8-6c38-441f-b564-8313925a4bc1"), "David's Dictionary", "David Doe"));
        books.add(new Book(UUID.fromString("5d910000-6e39-496b-9004-ab7df33e6323"), "Emma's Encyclopedia", "Emma Doe"));
        return books;
    }

    public List<Book> getAll() {
        return BOOKS.stream().sorted((book1, book2) -> book1.getId().compareTo(book2.getId())).collect(Collectors.toList());
    }

    public Book get(UUID id) {
        return BOOKS.stream().filter(book -> book.getId().equals(id)).findFirst().orElse(null);
    }

    public List<Book> getAllAfter(UUID after) {
        return this.getAll().stream().filter(book -> book.getId().compareTo(after) > 0).collect(Collectors.toList());
    }

    public Book create(Book book) {
        book.setId(UUID.randomUUID());
        BOOKS.add(book);
        return book;
    }

    public Book update(UUID id, Book book) {
        Book existingBook = this.get(id);
        if (existingBook != null) {
            existingBook.setTitle(book.getTitle());
            existingBook.setAuthor(book.getAuthor());
        }
        return existingBook;
    }

    public Book delete(UUID id) {
        Book existingBook = this.get(id);
        BOOKS.remove(existingBook);
        return existingBook;
    }
}

