/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.service.book.rest.service.helper;

import io.americanexpress.data.book.entity.BookEntity;
import io.americanexpress.service.book.rest.model.CreateBookServiceRequest;
import io.americanexpress.service.book.rest.model.CreateBookServiceResponse;
import io.americanexpress.service.book.rest.model.ReadBookServiceResponse;
import io.americanexpress.service.book.rest.model.UpdateBookServiceRequest;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class BookServiceMapper {
    private final Random random = new Random();

    public BookEntity mapCreateRequestToEntity(CreateBookServiceRequest createBookRequest) {
        BookEntity bookEntity = null;
        if (createBookRequest != null) {
            bookEntity = new BookEntity();
            bookEntity.setId(Long.valueOf(this.random.nextLong(1000L)));
            bookEntity.setAuthor(createBookRequest.getAuthor());
            bookEntity.setTitle(createBookRequest.getTitle());
            bookEntity.setDescription(createBookRequest.getDescription());
        }
        return bookEntity;
    }

    public CreateBookServiceResponse mapCreateBookResponse(BookEntity bookEntity) {
        CreateBookServiceResponse createBookResponse = null;
        if (bookEntity != null) {
            createBookResponse = new CreateBookServiceResponse();
            createBookResponse.setId(String.valueOf(bookEntity.getId()));
        }
        return createBookResponse;
    }

    public ReadBookServiceResponse mapEntityToReadResponse(BookEntity bookEntity) {
        ReadBookServiceResponse readBookResponse = null;
        if (bookEntity != null) {
            readBookResponse = new ReadBookServiceResponse();
            readBookResponse.setId(Long.toString(bookEntity.getId()));
            readBookResponse.setAuthor(bookEntity.getAuthor());
            readBookResponse.setTitle(bookEntity.getTitle());
            readBookResponse.setDescription(bookEntity.getDescription());
        }
        return readBookResponse;
    }

    public BookEntity mapUpdateRequestToEntity(UpdateBookServiceRequest updateBookRequest, BookEntity bookEntity) {
        if (StringUtils.isNotBlank((CharSequence)updateBookRequest.getAuthor())) {
            bookEntity.setAuthor(updateBookRequest.getAuthor());
        }
        if (StringUtils.isNotBlank((CharSequence)updateBookRequest.getTitle())) {
            bookEntity.setTitle(updateBookRequest.getTitle());
        }
        if (StringUtils.isNotBlank((CharSequence)updateBookRequest.getDescription())) {
            bookEntity.setDescription(updateBookRequest.getDescription());
        }
        return bookEntity;
    }
}

