/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.service.book.rest.service;

import io.americanexpress.data.book.entity.BookEntity;
import io.americanexpress.data.book.repository.BookRepository;
import io.americanexpress.service.book.rest.model.UpdateBookServiceRequest;
import io.americanexpress.service.book.rest.service.helper.BookServiceMapper;
import io.americanexpress.synapse.framework.exception.ApplicationClientException;
import io.americanexpress.synapse.framework.exception.model.ErrorCode;
import io.americanexpress.synapse.service.rest.service.BaseUpdateService;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Service;

@Service
public class UpdateBookService
extends BaseUpdateService<UpdateBookServiceRequest> {
    private final BookRepository bookRepository;
    private final BookServiceMapper bookServiceMapper;

    public UpdateBookService(BookRepository bookRepository, BookServiceMapper bookServiceMapper) {
        this.bookRepository = bookRepository;
        this.bookServiceMapper = bookServiceMapper;
    }

    protected void executeUpdate(HttpHeaders headers, UpdateBookServiceRequest request) {
        BookEntity bookEntity = this.bookRepository.findByAuthor(request.getAuthor());
        if (bookEntity == null) {
            throw new ApplicationClientException("Bad request", ErrorCode.GENERIC_4XX_ERROR, (String[])null);
        }
        this.bookRepository.save((Object)this.bookServiceMapper.mapUpdateRequestToEntity(request, bookEntity));
    }
}

