/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.service.book.rest.service;

import io.americanexpress.data.book.entity.BookEntity;
import io.americanexpress.data.book.repository.BookRepository;
import io.americanexpress.service.book.rest.model.ReadBookServiceRequest;
import io.americanexpress.service.book.rest.model.ReadBookServiceResponse;
import io.americanexpress.service.book.rest.service.helper.BookServiceMapper;
import io.americanexpress.synapse.service.rest.service.BaseReadMonoService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Service;

@Service
public class ReadBookService
extends BaseReadMonoService<ReadBookServiceRequest, ReadBookServiceResponse> {
    private final BookRepository bookRepository;
    private final BookServiceMapper bookServiceMapper;

    public ReadBookService(BookRepository bookRepository, BookServiceMapper bookServiceMapper) {
        this.bookRepository = bookRepository;
        this.bookServiceMapper = bookServiceMapper;
    }

    protected ReadBookServiceResponse executeRead(HttpHeaders headers, ReadBookServiceRequest request) {
        BookEntity bookEntity = null;
        if (request.getId() != null) {
            bookEntity = this.bookRepository.findById((Object)request.getId()).orElse(null);
        } else if (StringUtils.isNotBlank((CharSequence)request.getAuthor())) {
            bookEntity = this.bookRepository.findByAuthor(request.getAuthor());
        } else if (StringUtils.isNotBlank((CharSequence)request.getTitle())) {
            bookEntity = this.bookRepository.findByTitle(request.getTitle());
        }
        return this.bookServiceMapper.mapEntityToReadResponse(bookEntity);
    }
}

