/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.sample.client.reactive.football.config;

import io.americanexpress.sample.client.reactive.football.client.FootballGetReactiveRestClient;
import io.americanexpress.sample.client.reactive.football.handler.FootballReactiveResponseErrorHandler;
import io.americanexpress.synapse.client.rest.client.BaseReactiveRestClient;
import io.americanexpress.synapse.client.rest.config.BaseReactiveRestClientConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import reactor.netty.http.client.HttpClient;
import reactor.netty.transport.ProxyProvider;

@Configuration
@ComponentScan(value={"io.americanexpress.sample.client.reactive.football"})
@PropertySource(value={"classpath:client-football.properties"})
public class FootballReactiveClientConfig
extends BaseReactiveRestClientConfig {
    protected Environment environment;
    private final FootballGetReactiveRestClient footballReactiveClient;
    private final FootballReactiveResponseErrorHandler footballReactiveResponseErrorHandler;

    public FootballReactiveClientConfig(FootballGetReactiveRestClient footballReactiveClient, FootballReactiveResponseErrorHandler footballReactiveResponseErrorHandler, Environment environment) {
        this.footballReactiveClient = footballReactiveClient;
        this.footballReactiveResponseErrorHandler = footballReactiveResponseErrorHandler;
        this.environment = environment;
    }

    @Value(value="${football.client.url}")
    protected void initialize(String destinationUrl) {
        this.initializeClient(destinationUrl, (BaseReactiveRestClient)this.footballReactiveClient);
    }

    protected ReactorClientHttpConnector defaultClientConnector() {
        HttpClient httpClient = (HttpClient)HttpClient.create().proxy(proxy -> proxy.type(ProxyProvider.Proxy.HTTP).host(this.environment.getRequiredProperty("football.client.proxy.host")).port(Integer.valueOf(this.environment.getRequiredProperty("football.client.proxy.port")).intValue()));
        return new ReactorClientHttpConnector(httpClient);
    }
}

