/*
 * Decompiled with CFR 0.152.
 */
package io.americanexpress.service.book.graphql.resolver.query;

import graphql.kickstart.tools.GraphQLQueryResolver;
import graphql.relay.Connection;
import io.americanexpress.service.book.graphql.model.Book;
import io.americanexpress.service.book.graphql.service.BookService;
import io.americanexpress.synapse.service.graphql.model.ReactivePageable;
import io.americanexpress.synapse.service.graphql.model.ReactiveResponseCreator;
import io.americanexpress.synapse.service.graphql.pagination.ConnectionUtil;
import io.americanexpress.synapse.service.graphql.pagination.UUIDUtil;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component
public class BookReactiveQueryResolver
implements GraphQLQueryResolver,
ReactivePageable<Book> {
    private final BookService bookService;

    @Autowired
    public BookReactiveQueryResolver(BookService bookService) {
        this.bookService = bookService;
    }

    public CompletableFuture<List<Book>> getBooksReactively() {
        return ReactiveResponseCreator.create(this.bookService.getAll());
    }

    public CompletableFuture<Book> getBookReactively(UUID id) {
        return ReactiveResponseCreator.create((Object)this.bookService.get(id));
    }

    public CompletableFuture<Connection<Book>> getPaginatedElementsReactively(int first, String after) {
        return Mono.fromSupplier(() -> {
            List<Book> books = this.bookService.getAll();
            if (after != null && !after.isBlank()) {
                books = this.bookService.getAllAfter(UUIDUtil.toUUID((String)after));
            }
            return ConnectionUtil.create(books, (long)first, (String)after);
        }).toFuture();
    }
}

