/*
 * Decompiled with CFR 0.152.
 */
package io.alwaysonmobile.hullo.api.client;

import com.fasterxml.jackson.core.type.TypeReference;
import io.alwaysonmobile.hullo.api.ApiClient;
import io.alwaysonmobile.hullo.api.ApiException;
import io.alwaysonmobile.hullo.api.Configuration;
import io.alwaysonmobile.hullo.api.Pair;
import io.alwaysonmobile.hullo.api.client.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

public class MessagesApi {
    private ApiClient apiClient;

    public MessagesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MessagesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Message createMessage(Message message) throws ApiException {
        return this.createMessage(message, Collections.emptyMap());
    }

    public Message createMessage(Message message, Map<String, String> additionalHeaders) throws ApiException {
        Message localVarPostBody = message;
        if (message == null) {
            throw new ApiException(400, "Missing the required parameter 'message' when calling createMessage");
        }
        String localVarPath = "/endpoints/messages";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        TypeReference<Message> localVarReturnType = new TypeReference<Message>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<Message> getMessages(String phoneNumber, Integer limit) throws ApiException {
        return this.getMessages(phoneNumber, limit, Collections.emptyMap());
    }

    public List<Message> getMessages(String phoneNumber, Integer limit, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (phoneNumber == null) {
            throw new ApiException(400, "Missing the required parameter 'phoneNumber' when calling getMessages");
        }
        String localVarPath = "/endpoints/messages/{phoneNumber}".replaceAll("\\{phoneNumber\\}", this.apiClient.escapeString(phoneNumber.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        TypeReference<List<Message>> localVarReturnType = new TypeReference<List<Message>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

