/*
 * Decompiled with CFR 0.152.
 */
package io.alwaysonmobile.hullo.api.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum MessageStatus {
    FAILED("FAILED"),
    ACCEPTED("ACCEPTED"),
    DELIVERED("DELIVERED"),
    ISSUED("ISSUED"),
    REJECTED("REJECTED"),
    UNKNOWN("UNKNOWN"),
    PENDING("PENDING"),
    STAGING("STAGING"),
    N_A("N/A");

    private String value;

    private MessageStatus(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static MessageStatus fromValue(String value) {
        for (MessageStatus b : MessageStatus.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        return String.format("%s=%s", prefix, this.toString());
    }
}

