/*
 * Decompiled with CFR 0.152.
 */
package io.alwaysonmobile.hullo.api.client;

import com.fasterxml.jackson.core.type.TypeReference;
import io.alwaysonmobile.hullo.api.ApiClient;
import io.alwaysonmobile.hullo.api.ApiException;
import io.alwaysonmobile.hullo.api.Configuration;
import io.alwaysonmobile.hullo.api.Pair;
import io.alwaysonmobile.hullo.api.client.Member;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;

public class MembersApi {
    private ApiClient apiClient;

    public MembersApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MembersApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Member getMember(String phoneNumber) throws ApiException {
        return this.getMember(phoneNumber, Collections.emptyMap());
    }

    public Member getMember(String phoneNumber, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (phoneNumber == null) {
            throw new ApiException(400, "Missing the required parameter 'phoneNumber' when calling getMember");
        }
        String localVarPath = "/endpoints/members/{phoneNumber}".replaceAll("\\{phoneNumber\\}", this.apiClient.escapeString(phoneNumber.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        TypeReference<Member> localVarReturnType = new TypeReference<Member>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void optOutMember(String phoneNumber) throws ApiException {
        this.optOutMember(phoneNumber, Collections.emptyMap());
    }

    public void optOutMember(String phoneNumber, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (phoneNumber == null) {
            throw new ApiException(400, "Missing the required parameter 'phoneNumber' when calling optOutMember");
        }
        String localVarPath = "/endpoints/members/{phoneNumber}/optout".replaceAll("\\{phoneNumber\\}", this.apiClient.escapeString(phoneNumber.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public Member upsertMember(Member member) throws ApiException {
        return this.upsertMember(member, Collections.emptyMap());
    }

    public Member upsertMember(Member member, Map<String, String> additionalHeaders) throws ApiException {
        Member localVarPostBody = member;
        if (member == null) {
            throw new ApiException(400, "Missing the required parameter 'member' when calling upsertMember");
        }
        String localVarPath = "/endpoints/members";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        TypeReference<Member> localVarReturnType = new TypeReference<Member>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

