/*
 * Decompiled with CFR 0.152.
 */
package io.alwaysonmobile.hullo.api.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"registrationDate", "phoneNumber", "fullName", "attributes", "groups"})
public class Member {
    public static final String JSON_PROPERTY_REGISTRATION_DATE = "registrationDate";
    private OffsetDateTime registrationDate;
    public static final String JSON_PROPERTY_PHONE_NUMBER = "phoneNumber";
    private String phoneNumber;
    public static final String JSON_PROPERTY_FULL_NAME = "fullName";
    private String fullName;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private Map<String, List<String>> attributes = new HashMap<String, List<String>>();
    public static final String JSON_PROPERTY_GROUPS = "groups";
    private List<String> groups;

    public Member registrationDate(OffsetDateTime registrationDate) {
        this.registrationDate = registrationDate;
        return this;
    }

    @Nullable
    @JsonProperty(value="registrationDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getRegistrationDate() {
        return this.registrationDate;
    }

    @JsonProperty(value="registrationDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRegistrationDate(OffsetDateTime registrationDate) {
        this.registrationDate = registrationDate;
    }

    public Member phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @Nonnull
    @JsonProperty(value="phoneNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonProperty(value="phoneNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public Member fullName(String fullName) {
        this.fullName = fullName;
        return this;
    }

    @Nullable
    @JsonProperty(value="fullName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFullName() {
        return this.fullName;
    }

    @JsonProperty(value="fullName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public Member attributes(Map<String, List<String>> attributes) {
        this.attributes = attributes;
        return this;
    }

    public Member putAttributesItem(String key, List<String> attributesItem) {
        this.attributes.put(key, attributesItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAttributes(Map<String, List<String>> attributes) {
        this.attributes = attributes;
    }

    public Member groups(List<String> groups) {
        this.groups = groups;
        return this;
    }

    public Member addGroupsItem(String groupsItem) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.add(groupsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="groups")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getGroups() {
        return this.groups;
    }

    @JsonProperty(value="groups")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Member member = (Member)o;
        return Objects.equals(this.registrationDate, member.registrationDate) && Objects.equals(this.phoneNumber, member.phoneNumber) && Objects.equals(this.fullName, member.fullName) && Objects.equals(this.attributes, member.attributes) && Objects.equals(this.groups, member.groups);
    }

    public int hashCode() {
        return Objects.hash(this.registrationDate, this.phoneNumber, this.fullName, this.attributes, this.groups);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Member {\n");
        sb.append("    registrationDate: ").append(this.toIndentedString(this.registrationDate)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    fullName: ").append(this.toIndentedString(this.fullName)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    groups: ").append(this.toIndentedString(this.groups)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getRegistrationDate() != null) {
            try {
                joiner.add(String.format("%sregistrationDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getRegistrationDate()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getPhoneNumber() != null) {
            try {
                joiner.add(String.format("%sphoneNumber%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getPhoneNumber()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getFullName() != null) {
            try {
                joiner.add(String.format("%sfullName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getFullName()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getAttributes() != null) {
            for (String _key : this.getAttributes().keySet()) {
                try {
                    joiner.add(String.format("%sattributes%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getAttributes().get(_key), URLEncoder.encode(String.valueOf(this.getAttributes().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getGroups() != null) {
            for (int i = 0; i < this.getGroups().size(); ++i) {
                try {
                    joiner.add(String.format("%sgroups%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getGroups().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return joiner.toString();
    }
}

