/*
 * Decompiled with CFR 0.152.
 */
package io.alwaysonmobile.hullo.api.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.alwaysonmobile.hullo.api.client.AttributeEditType;
import io.alwaysonmobile.hullo.api.client.AttributeType;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"name", "type", "displayOrder", "editType", "listItems"})
public class Attribute {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_TYPE = "type";
    private AttributeType type;
    public static final String JSON_PROPERTY_DISPLAY_ORDER = "displayOrder";
    private Integer displayOrder;
    public static final String JSON_PROPERTY_EDIT_TYPE = "editType";
    private AttributeEditType editType;
    public static final String JSON_PROPERTY_LIST_ITEMS = "listItems";
    private List<String> listItems;

    public Attribute name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public Attribute type(AttributeType type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AttributeType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(AttributeType type) {
        this.type = type;
    }

    public Attribute displayOrder(Integer displayOrder) {
        this.displayOrder = displayOrder;
        return this;
    }

    @Nullable
    @JsonProperty(value="displayOrder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getDisplayOrder() {
        return this.displayOrder;
    }

    @JsonProperty(value="displayOrder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayOrder(Integer displayOrder) {
        this.displayOrder = displayOrder;
    }

    public Attribute editType(AttributeEditType editType) {
        this.editType = editType;
        return this;
    }

    @Nullable
    @JsonProperty(value="editType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AttributeEditType getEditType() {
        return this.editType;
    }

    @JsonProperty(value="editType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEditType(AttributeEditType editType) {
        this.editType = editType;
    }

    public Attribute listItems(List<String> listItems) {
        this.listItems = listItems;
        return this;
    }

    public Attribute addListItemsItem(String listItemsItem) {
        if (this.listItems == null) {
            this.listItems = new ArrayList<String>();
        }
        this.listItems.add(listItemsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="listItems")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getListItems() {
        return this.listItems;
    }

    @JsonProperty(value="listItems")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setListItems(List<String> listItems) {
        this.listItems = listItems;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attribute attribute = (Attribute)o;
        return Objects.equals(this.name, attribute.name) && Objects.equals((Object)this.type, (Object)attribute.type) && Objects.equals(this.displayOrder, attribute.displayOrder) && Objects.equals((Object)this.editType, (Object)attribute.editType) && Objects.equals(this.listItems, attribute.listItems);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.displayOrder, this.editType, this.listItems});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Attribute {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    displayOrder: ").append(this.toIndentedString(this.displayOrder)).append("\n");
        sb.append("    editType: ").append(this.toIndentedString((Object)this.editType)).append("\n");
        sb.append("    listItems: ").append(this.toIndentedString(this.listItems)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getName() != null) {
            try {
                joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getType() != null) {
            try {
                joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getType()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getDisplayOrder() != null) {
            try {
                joiner.add(String.format("%sdisplayOrder%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDisplayOrder()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getEditType() != null) {
            try {
                joiner.add(String.format("%seditType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getEditType()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getListItems() != null) {
            for (int i = 0; i < this.getListItems().size(); ++i) {
                try {
                    joiner.add(String.format("%slistItems%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getListItems().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return joiner.toString();
    }
}

