/*
 * Decompiled with CFR 0.152.
 */
package io.alwaysonmobile.hullo.api;

import io.alwaysonmobile.hullo.api.client.GenericError;
import java.util.List;
import java.util.Map;

public class ApiException
extends Exception {
    private static final long serialVersionUID = 1L;
    private int code = 0;
    private Map<String, List<String>> responseHeaders = null;
    private String responseBody = null;
    private GenericError error = null;

    public ApiException() {
    }

    public ApiException(Throwable throwable) {
        super(throwable);
    }

    public ApiException(String message) {
        super(message);
    }

    public ApiException(String message, Throwable throwable, int code, Map<String, List<String>> responseHeaders, String responseBody) {
        super(message, throwable);
        this.code = code;
        this.responseHeaders = responseHeaders;
        this.responseBody = responseBody;
    }

    public ApiException(String message, Throwable throwable, int code, Map<String, List<String>> responseHeaders, String responseBody, GenericError error) {
        super(message, throwable);
        this.code = code;
        this.responseHeaders = responseHeaders;
        this.responseBody = responseBody;
        this.error = error;
    }

    public ApiException(String message, int code, Map<String, List<String>> responseHeaders, String responseBody) {
        this(message, (Throwable)null, code, responseHeaders, responseBody);
    }

    public ApiException(String message, int code, Map<String, List<String>> responseHeaders, String responseBody, GenericError error) {
        this(message, null, code, responseHeaders, responseBody, error);
    }

    public ApiException(String message, Throwable throwable, int code, Map<String, List<String>> responseHeaders) {
        this(message, throwable, code, responseHeaders, (String)null);
    }

    public ApiException(String message, Throwable throwable, int code, Map<String, List<String>> responseHeaders, GenericError error) {
        this(message, throwable, code, responseHeaders, null, error);
    }

    public ApiException(int code, Map<String, List<String>> responseHeaders, String responseBody) {
        this("Response Code: " + code + " Response Body: " + responseBody, (Throwable)null, code, responseHeaders, responseBody);
    }

    public ApiException(int code, Map<String, List<String>> responseHeaders, String responseBody, GenericError error) {
        this("Response Code: " + code + " Response Body: " + responseBody, null, code, responseHeaders, responseBody, error);
    }

    public ApiException(int code, String message) {
        super(message);
        this.code = code;
    }

    public ApiException(int code, String message, GenericError error) {
        super(message);
        this.code = code;
        this.error = error;
    }

    public ApiException(int code, String message, Map<String, List<String>> responseHeaders, String responseBody) {
        this(code, message);
        this.responseHeaders = responseHeaders;
        this.responseBody = responseBody;
    }

    public ApiException(int code, String message, Map<String, List<String>> responseHeaders, String responseBody, GenericError error) {
        this(code, message);
        this.responseHeaders = responseHeaders;
        this.responseBody = responseBody;
        this.error = error;
    }

    public int getCode() {
        return this.code;
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.responseHeaders;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public GenericError getError() {
        return this.error;
    }

    @Override
    public String toString() {
        return "ApiException{code=" + this.code + ", responseHeaders=" + this.responseHeaders + ", responseBody='" + this.responseBody + '\'' + '}';
    }
}

