/*
 * Always On Mobile - hullo API
 * Welcome to the hullo API.    With this API you can perform operations on your hullo account programmatically that you can call using the hullo console. The operations currently available include:    * Add / Update a member * Get the details of a member * Get the messages sent / received from a member * Send a message to a member  The hullo API is an easy to use RESTful API that can be called by any modern programming language that  supports HTTP calls, and also has out of the box support for several programming languages including:   * Java * Javascript    In order to use the API you will first need to generate an API key using the hullo console application, assigning it the the relevant scopes required for the operations you wish to call. 
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package io.alwaysonmobile.hullo.api.client;

import com.fasterxml.jackson.core.type.TypeReference;

import io.alwaysonmobile.hullo.api.ApiException;
import io.alwaysonmobile.hullo.api.ApiClient;
import io.alwaysonmobile.hullo.api.Configuration;
import io.alwaysonmobile.hullo.api.client.*;
import io.alwaysonmobile.hullo.api.Pair;

import io.alwaysonmobile.hullo.api.client.GenericError;
import io.alwaysonmobile.hullo.api.client.Member;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-05-07T11:42:47.246+01:00[Europe/London]")
public class MembersApi {


  private ApiClient apiClient;

  public MembersApi() {
    this(Configuration.getDefaultApiClient());
  }

  public MembersApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Gets the details for a member
   * Retrieves the details hullo stores about a specific member. The record will contain any attribute data added  using either the hullo API or the hullo application along with the members phone number and full name. 
   * @param phoneNumber The phone number of the subscriber (required)
   * @return Member
   * @throws ApiException if fails to make API call
   */
  public Member getMember(String phoneNumber) throws ApiException {
    return this.getMember(phoneNumber, Collections.emptyMap());
  }


  /**
   * Gets the details for a member
   * Retrieves the details hullo stores about a specific member. The record will contain any attribute data added  using either the hullo API or the hullo application along with the members phone number and full name. 
   * @param phoneNumber The phone number of the subscriber (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return Member
   * @throws ApiException if fails to make API call
   */
  public Member getMember(String phoneNumber, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'phoneNumber' is set
    if (phoneNumber == null) {
      throw new ApiException(400, "Missing the required parameter 'phoneNumber' when calling getMember");
    }
    
    // create path and map variables
    String localVarPath = "/endpoints/members/{phoneNumber}"
      .replaceAll("\\{" + "phoneNumber" + "\\}", apiClient.escapeString(phoneNumber.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "ApiKeyAuth" };

    TypeReference<Member> localVarReturnType = new TypeReference<Member>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Opts the member out from the hullo member store
   * Opts out the member from the hullo member store which results in their record being deleted. Any pending  messages will also be deleted for the member and the member will no longer be able to participate in \\ any  campaigns. 
   * @param phoneNumber The phone number of the subscriber (required)
   * @throws ApiException if fails to make API call
   */
  public void optOutMember(String phoneNumber) throws ApiException {
    this.optOutMember(phoneNumber, Collections.emptyMap());
  }


  /**
   * Opts the member out from the hullo member store
   * Opts out the member from the hullo member store which results in their record being deleted. Any pending  messages will also be deleted for the member and the member will no longer be able to participate in \\ any  campaigns. 
   * @param phoneNumber The phone number of the subscriber (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void optOutMember(String phoneNumber, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'phoneNumber' is set
    if (phoneNumber == null) {
      throw new ApiException(400, "Missing the required parameter 'phoneNumber' when calling optOutMember");
    }
    
    // create path and map variables
    String localVarPath = "/endpoints/members/{phoneNumber}/optout"
      .replaceAll("\\{" + "phoneNumber" + "\\}", apiClient.escapeString(phoneNumber.toString()));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "ApiKeyAuth" };

    apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Adds or updates a member
   * Add or update the information hullo stores for a specific member. If the member doesn&#39;t already exist then    they will be added to the members store and an opt-in message will be sent to the number specified in order   to get confirmation that the number exists and wishes to receive messages. If the member responds with a   confirmation message (\&quot;yes\&quot;) then their member record will be updated to opted-in and they will then be able   to receive messages sent to them from any hullo campaign. If the member already exists then their record will  be updated to reflect any new / updated attribute data included in the call. If an attribute is specified but   no value is given or the value is null then that attribute will be deleted from the members record. 
   * @param member A JSON object containing member information (required)
   * @return Member
   * @throws ApiException if fails to make API call
   */
  public Member upsertMember(Member member) throws ApiException {
    return this.upsertMember(member, Collections.emptyMap());
  }


  /**
   * Adds or updates a member
   * Add or update the information hullo stores for a specific member. If the member doesn&#39;t already exist then    they will be added to the members store and an opt-in message will be sent to the number specified in order   to get confirmation that the number exists and wishes to receive messages. If the member responds with a   confirmation message (\&quot;yes\&quot;) then their member record will be updated to opted-in and they will then be able   to receive messages sent to them from any hullo campaign. If the member already exists then their record will  be updated to reflect any new / updated attribute data included in the call. If an attribute is specified but   no value is given or the value is null then that attribute will be deleted from the members record. 
   * @param member A JSON object containing member information (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return Member
   * @throws ApiException if fails to make API call
   */
  public Member upsertMember(Member member, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = member;
    
    // verify the required parameter 'member' is set
    if (member == null) {
      throw new ApiException(400, "Missing the required parameter 'member' when calling upsertMember");
    }
    
    // create path and map variables
    String localVarPath = "/endpoints/members";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "ApiKeyAuth" };

    TypeReference<Member> localVarReturnType = new TypeReference<Member>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

}
