/*
 * Always On Mobile - hullo API
 * Welcome to the hullo API.    With this API you can perform operations on your hullo account programmatically that you can call using the hullo console. The operations currently available include:    * Add / Update a member * Get the details of a member * Get the messages sent / received from a member * Send a message to a member  The hullo API is an easy to use RESTful API that can be called by any modern programming language that  supports HTTP calls, and also has out of the box support for several programming languages including:   * Java * Javascript    In order to use the API you will first need to generate an API key using the hullo console application, assigning it the the relevant scopes required for the operations you wish to call. 
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.alwaysonmobile.hullo.api.client;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * **Provides information about the error that occurred when calling an operation. The code can be one of the following:** | Status           | Code        | Reason                                                                                                                                                     | | ---------------- | ------------| -----------------------------------------------------------------------------------------------------------------------------------------------------------| | 500              | SE001       | HTTP 500 Internal Server Error                                                                                                                             | | 500              | SE002       | HTTP 500 Internal Server Error - Configuration Error                                                                                                       | | 500              | SE003       | HTTP 500 Internal Server Error - External System Error                                                                                                     | | 400              | BR001       | JSON request invalid, it must contain %s in a valid JSON format                                                                                            | | 400              | BR002       | The &#39;%s&#39; parameter must be provided                                                                                                                        | | 400              | BR003       | The request body was not valid                                                                                                                             | | 400              | BR004       | The &#39;%s&#39; parameter must be in the ISO-8601 extended offset date-time format                                                                                | | 400              | BR012       | The account does not have enough credit to send the requested message. Estimated credit required: %s Credit available: %s                                  | | 400              | BR013       | The &#39;%s&#39; parameter must be at least %s seconds or more in the future                                                                                       | | 400              | BR016       | The &#39;%s&#39; parameter must be between %s and %s characters                                                                                                    | | 400              | BR025       | The &#39;%s&#39; parameter must contain a valid value                                                                                                              | | 400              | BR027       | Member not opted in                                                                                                                                        | | 400              | BR039       | Member opted out                                                                                                                                           | | 400              | BR044       | At least one of the specified parameters &#39;%s&#39; must be provided                                                                                             | | 400              | BR049       | %s is a mandatory attribute and must be provided                                                                                                           | | 401              | UA001       | Access denied: check API key                                                                                                                               | | 401              | UA002       | Access denied: &#39;%s&#39;                                                                                                                                        | | 401              | UA005       | Account disabled                                                                                                                                           | | 403              | FB001       | Access denied                                                                                                                                              | | 404              | NF001       | %s not found                                                                                                                                               | | 429              | TR001       | Too Many Requests                                                                                                                                          | 
 */
@JsonPropertyOrder({
  GenericError.JSON_PROPERTY_CODE,
  GenericError.JSON_PROPERTY_TEXT
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-05-07T11:42:47.246+01:00[Europe/London]")
public class GenericError {
  public static final String JSON_PROPERTY_CODE = "code";
  private String code;

  public static final String JSON_PROPERTY_TEXT = "text";
  private String text;

  public GenericError() {
  }

  public GenericError code(String code) {
    
    this.code = code;
    return this;
  }

   /**
   * Get code
   * @return code
  **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCode() {
    return code;
  }


  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCode(String code) {
    this.code = code;
  }


  public GenericError text(String text) {
    
    this.text = text;
    return this;
  }

   /**
   * Get text
   * @return text
  **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getText() {
    return text;
  }


  @JsonProperty(JSON_PROPERTY_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setText(String text) {
    this.text = text;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GenericError genericError = (GenericError) o;
    return Objects.equals(this.code, genericError.code) &&
        Objects.equals(this.text, genericError.text);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, text);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GenericError {\n");
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    text: ").append(toIndentedString(text)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `code` to the URL query string
    if (getCode() != null) {
      try {
        joiner.add(String.format("%scode%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCode()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `text` to the URL query string
    if (getText() != null) {
      try {
        joiner.add(String.format("%stext%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getText()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

