/*
 * Always On Mobile - hullo API
 * Welcome to the hullo API.    With this API you can perform operations on your hullo account programmatically that you can call using the hullo console. The operations currently available include:    * Add / Update a member * Get the details of a member * Get the messages sent / received from a member * Send a message to a member  The hullo API is an easy to use RESTful API that can be called by any modern programming language that  supports HTTP calls, and also has out of the box support for several programming languages including:   * Java * Javascript    In order to use the API you will first need to generate an API key using the hullo console application, assigning it the the relevant scopes required for the operations you wish to call. 
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.alwaysonmobile.hullo.api.client;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.alwaysonmobile.hullo.api.client.AttributeEditType;
import io.alwaysonmobile.hullo.api.client.AttributeType;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * An attribute definition
 */
@JsonPropertyOrder({
  Attribute.JSON_PROPERTY_NAME,
  Attribute.JSON_PROPERTY_TYPE,
  Attribute.JSON_PROPERTY_DISPLAY_ORDER,
  Attribute.JSON_PROPERTY_EDIT_TYPE,
  Attribute.JSON_PROPERTY_LIST_ITEMS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-05-07T11:42:47.246+01:00[Europe/London]")
public class Attribute {
  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_TYPE = "type";
  private AttributeType type;

  public static final String JSON_PROPERTY_DISPLAY_ORDER = "displayOrder";
  private Integer displayOrder;

  public static final String JSON_PROPERTY_EDIT_TYPE = "editType";
  private AttributeEditType editType;

  public static final String JSON_PROPERTY_LIST_ITEMS = "listItems";
  private List<String> listItems;

  public Attribute() {
  }

  public Attribute name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * The name of the attribute
   * @return name
  **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public Attribute type(AttributeType type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public AttributeType getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(AttributeType type) {
    this.type = type;
  }


  public Attribute displayOrder(Integer displayOrder) {
    
    this.displayOrder = displayOrder;
    return this;
  }

   /**
   * Get displayOrder
   * minimum: 0
   * @return displayOrder
  **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DISPLAY_ORDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getDisplayOrder() {
    return displayOrder;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_ORDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayOrder(Integer displayOrder) {
    this.displayOrder = displayOrder;
  }


  public Attribute editType(AttributeEditType editType) {
    
    this.editType = editType;
    return this;
  }

   /**
   * Get editType
   * @return editType
  **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EDIT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AttributeEditType getEditType() {
    return editType;
  }


  @JsonProperty(JSON_PROPERTY_EDIT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEditType(AttributeEditType editType) {
    this.editType = editType;
  }


  public Attribute listItems(List<String> listItems) {
    
    this.listItems = listItems;
    return this;
  }

  public Attribute addListItemsItem(String listItemsItem) {
    if (this.listItems == null) {
      this.listItems = new ArrayList<>();
    }
    this.listItems.add(listItemsItem);
    return this;
  }

   /**
   * Get listItems
   * @return listItems
  **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LIST_ITEMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getListItems() {
    return listItems;
  }


  @JsonProperty(JSON_PROPERTY_LIST_ITEMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setListItems(List<String> listItems) {
    this.listItems = listItems;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Attribute attribute = (Attribute) o;
    return Objects.equals(this.name, attribute.name) &&
        Objects.equals(this.type, attribute.type) &&
        Objects.equals(this.displayOrder, attribute.displayOrder) &&
        Objects.equals(this.editType, attribute.editType) &&
        Objects.equals(this.listItems, attribute.listItems);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, type, displayOrder, editType, listItems);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Attribute {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    displayOrder: ").append(toIndentedString(displayOrder)).append("\n");
    sb.append("    editType: ").append(toIndentedString(editType)).append("\n");
    sb.append("    listItems: ").append(toIndentedString(listItems)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `name` to the URL query string
    if (getName() != null) {
      try {
        joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `type` to the URL query string
    if (getType() != null) {
      try {
        joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `displayOrder` to the URL query string
    if (getDisplayOrder() != null) {
      try {
        joiner.add(String.format("%sdisplayOrder%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDisplayOrder()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `editType` to the URL query string
    if (getEditType() != null) {
      try {
        joiner.add(String.format("%seditType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getEditType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `listItems` to the URL query string
    if (getListItems() != null) {
      for (int i = 0; i < getListItems().size(); i++) {
        try {
          joiner.add(String.format("%slistItems%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getListItems().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    return joiner.toString();
  }

}

