/*
 * Always On Mobile - hullo API
 * Welcome to the hullo API.    With this API you can perform operations on your hullo account programmatically that you can call using the hullo console. The operations currently available include:    * Add / Update a member * Get the details of a member * Get the messages sent / received from a member * Send a message to a member  The hullo API is an easy to use RESTful API that can be called by any modern programming language that  supports HTTP calls, and also has out of the box support for several programming languages including:   * Java * Javascript    In order to use the API you will first need to generate an API key using the hullo console application, assigning it the the relevant scopes required for the operations you wish to call. 
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.alwaysonmobile.hullo.api;

import java.util.Map;
import java.util.List;
import io.alwaysonmobile.hullo.api.client.GenericError;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-05-07T11:42:47.246+01:00[Europe/London]")
public class ApiException extends Exception {
private static final long serialVersionUID = 1L;

    private int code = 0;
    private Map<String, List<String>> responseHeaders = null;
    private String responseBody = null;
    private GenericError error = null;

    public ApiException() {}

    public ApiException(Throwable throwable) {
        super(throwable);
    }

    public ApiException(String message) {
        super(message);
    }

    public ApiException(String message, Throwable throwable, int code, Map<String, List<String>> responseHeaders, String responseBody) {
        super(message, throwable);
        this.code = code;
        this.responseHeaders = responseHeaders;
        this.responseBody = responseBody;
    }

    public ApiException(String message, Throwable throwable, int code, Map<String, List<String>> responseHeaders, String responseBody, GenericError error) {
        super(message, throwable);
        this.code = code;
        this.responseHeaders = responseHeaders;
        this.responseBody = responseBody;
        this.error = error;
    }

    public ApiException(String message, int code, Map<String, List<String>> responseHeaders, String responseBody) {
        this(message, (Throwable) null, code, responseHeaders, responseBody);
    }

    public ApiException(String message, int code, Map<String, List<String>> responseHeaders, String responseBody, GenericError error) {
        this(message, (Throwable) null, code, responseHeaders, responseBody, error);
    }

    public ApiException(String message, Throwable throwable, int code, Map<String, List<String>> responseHeaders) {
        this(message, throwable, code, responseHeaders, (String) null);
    }

    public ApiException(String message, Throwable throwable, int code, Map<String, List<String>> responseHeaders, GenericError error) {
        this(message, throwable, code, responseHeaders, null, error);
    }

    public ApiException(int code, Map<String, List<String>> responseHeaders, String responseBody) {
        this("Response Code: " + code + " Response Body: " + responseBody, (Throwable) null, code, responseHeaders, responseBody);
    }

    public ApiException(int code, Map<String, List<String>> responseHeaders, String responseBody, GenericError error) {
        this("Response Code: " + code + " Response Body: " + responseBody, (Throwable) null, code, responseHeaders, responseBody, error);
    }

    public ApiException(int code, String message) {
        super(message);
        this.code = code;
    }

    public ApiException(int code, String message, GenericError error) {
        super(message);
        this.code = code;
        this.error = error;
    }

    public ApiException(int code, String message, Map<String, List<String>> responseHeaders, String responseBody) {
        this(code, message);
        this.responseHeaders = responseHeaders;
        this.responseBody = responseBody;
    }

    public ApiException(int code, String message, Map<String, List<String>> responseHeaders, String responseBody, GenericError error) {
        this(code, message);
        this.responseHeaders = responseHeaders;
        this.responseBody = responseBody;
        this.error = error;
    }

    /**
    * Get the HTTP status code.
    *
    * @return HTTP status code
    */
    public int getCode() {
        return code;
    }

    /**
    * Get the HTTP response headers.
    *
    * @return A map of list of string
    */
    public Map<String, List<String>> getResponseHeaders() {
        return responseHeaders;
    }

    /**
    * Get the HTTP response body.
    *
    * @return Response body in the form of string
    */
    public String getResponseBody() {
        return responseBody;
    }

    /**
    * Get the error object
    *
    * @return Generic error object
    */
    public GenericError getError() {
        return error;
    }

    @Override
    public String toString() {
        return "ApiException{" +
                "code=" + code +
                ", responseHeaders=" + responseHeaders +
                ", responseBody='" + responseBody + '\'' +
                '}';
    }
}