/*
 * Decompiled with CFR 0.152.
 */
package io.alauda;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import io.fabric8.kubernetes.client.server.mock.KubernetesServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="mock")
public class MockApiServer
extends AbstractMojo {
    @Parameter(defaultValue="${project.basedir}")
    private File basedir;
    @Parameter(name="resources")
    private List<String> resources;
    @Parameter(name="port", defaultValue="8443")
    private int port;

    public void execute() throws MojoExecutionException {
        File f = this.basedir;
        if (!f.exists()) {
            f.mkdirs();
        }
        KubernetesServer server = new KubernetesServer(true, true, InetAddress.getLoopbackAddress(), this.port, Collections.emptyList());
        server.before();
        NamespacedKubernetesClient client = server.getClient();
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        if (this.resources.size() == 0) {
            this.resources.add(Paths.get(this.basedir.toString(), new String[0]).resolve("kubernetes").toString());
            this.resources.add(Paths.get(this.basedir.toString(), new String[0]).resolve(".local").toString());
        }
        for (String resPath : this.resources) {
            try {
                if (!FileUtils.fileExists((String)resPath)) continue;
                this.loadResources((KubernetesClient)client, new File(resPath));
            }
            catch (FileNotFoundException e) {
                throw new MojoExecutionException("Failed to load resources!", (Exception)e);
            }
        }
        System.out.println("Press any key to stop the server");
        byte[] name = new byte[100];
        try {
            System.in.read(name);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to read stdin!", (Exception)e);
        }
    }

    private void loadResources(KubernetesClient client, File file) throws FileNotFoundException {
        if (file.isDirectory()) {
            File[] files;
            for (File f : files = file.listFiles()) {
                this.loadResources(client, f);
            }
        } else if (this.isYamlFile(file.getName())) {
            client.load((InputStream)new FileInputStream(file.getAbsolutePath())).createOrReplace();
        }
    }

    private boolean isYamlFile(String fileName) {
        return fileName.toLowerCase().endsWith("yaml") || fileName.toLowerCase().endsWith("yml");
    }
}

