/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.connect.common.templating;

import io.aiven.kafka.connect.common.templating.TemplateParser;
import io.aiven.kafka.connect.common.templating.TemplatePart;
import io.aiven.kafka.connect.common.templating.TextTemplatePart;
import io.aiven.kafka.connect.common.templating.VariableTemplatePart;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public final class Template {
    private final List<Pair<String, VariableTemplatePart.Parameter>> variablesAndParameters;
    private final List<TemplatePart> templateParts;
    private final String originalTemplateString;

    private Template(String template, List<Pair<String, VariableTemplatePart.Parameter>> variablesAndParameters, List<TemplatePart> templateParts) {
        this.originalTemplateString = template;
        this.variablesAndParameters = variablesAndParameters;
        this.templateParts = templateParts;
    }

    public String originalTemplate() {
        return this.originalTemplateString;
    }

    public final List<String> variables() {
        return this.variablesAndParameters.stream().map(Pair::getLeft).collect(Collectors.toList());
    }

    public final Set<String> variablesSet() {
        return this.variablesAndParameters.stream().map(Pair::getLeft).collect(Collectors.toSet());
    }

    public final List<Pair<String, VariableTemplatePart.Parameter>> variablesWithParameters() {
        return this.variablesAndParameters;
    }

    public final List<Pair<String, VariableTemplatePart.Parameter>> variablesWithNonEmptyParameters() {
        return this.variablesAndParameters.stream().filter(e -> !((VariableTemplatePart.Parameter)e.getRight()).isEmpty()).collect(Collectors.toList());
    }

    public final Instance instance() {
        return new Instance();
    }

    public static Template of(String template) {
        Pair<List<Pair<String, VariableTemplatePart.Parameter>>, List<TemplatePart>> parsingResult = TemplateParser.parse(template);
        return new Template(template, (List)parsingResult.getLeft(), (List)parsingResult.getRight());
    }

    public String toString() {
        return this.originalTemplateString;
    }

    public final class Instance {
        private final Map<String, Function<VariableTemplatePart.Parameter, String>> bindings = new HashMap<String, Function<VariableTemplatePart.Parameter, String>>();

        private Instance() {
        }

        public final Instance bindVariable(String name, Supplier<String> binding) {
            return this.bindVariable(name, (VariableTemplatePart.Parameter x) -> (String)binding.get());
        }

        public final Instance bindVariable(String name, Function<VariableTemplatePart.Parameter, String> binding) {
            Objects.requireNonNull(name, "name cannot be null");
            Objects.requireNonNull(binding, "binding cannot be null");
            if (name.trim().isEmpty()) {
                throw new IllegalArgumentException("name must not be empty");
            }
            this.bindings.put(name, binding);
            return this;
        }

        public final String render() {
            StringBuilder sb = new StringBuilder();
            for (TemplatePart templatePart : Template.this.templateParts) {
                if (templatePart instanceof TextTemplatePart) {
                    sb.append(((TextTemplatePart)templatePart).text());
                    continue;
                }
                if (!(templatePart instanceof VariableTemplatePart)) continue;
                VariableTemplatePart variableTemplatePart = (VariableTemplatePart)templatePart;
                Function<VariableTemplatePart.Parameter, String> binding = this.bindings.get(variableTemplatePart.variableName());
                if (Objects.nonNull(binding)) {
                    sb.append(binding.apply(variableTemplatePart.parameter()));
                    continue;
                }
                sb.append(variableTemplatePart.originalPlaceholder());
            }
            return sb.toString();
        }
    }
}

