/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.connect.common.output.jsonwriter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.aiven.kafka.connect.common.output.OutputStreamWriter;
import io.aiven.kafka.connect.common.output.jsonwriter.OutputFieldBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.connect.sink.SinkRecord;

public class JsonLinesOutputStreamWriter
implements OutputStreamWriter {
    private static final byte[] RECORD_SEPARATOR = "\n".getBytes(StandardCharsets.UTF_8);
    private final Map<String, OutputFieldBuilder> fieldBuilders;
    private final boolean envelopeEnabled;
    private final ObjectMapper objectMapper;

    JsonLinesOutputStreamWriter(Map<String, OutputFieldBuilder> fieldBuilders, boolean envelopeEnabled) {
        this.fieldBuilders = fieldBuilders;
        this.envelopeEnabled = envelopeEnabled;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.setNodeFactory(JsonNodeFactory.withExactBigDecimals((boolean)true));
    }

    @Override
    public void writeRecordsSeparator(OutputStream outputStream) throws IOException {
        outputStream.write(RECORD_SEPARATOR);
    }

    @Override
    public void writeOneRecord(OutputStream outputStream, SinkRecord record) throws IOException {
        outputStream.write(this.objectMapper.writeValueAsBytes((Object)this.getFields(record)));
    }

    private JsonNode getFields(SinkRecord record) throws IOException {
        if (this.envelopeEnabled) {
            ObjectNode root = JsonNodeFactory.instance.objectNode();
            Set<Map.Entry<String, OutputFieldBuilder>> entries = this.fieldBuilders.entrySet();
            for (Map.Entry<String, OutputFieldBuilder> entry : entries) {
                JsonNode node = entry.getValue().build(record);
                root.set(entry.getKey(), node);
            }
            return root;
        }
        return this.fieldBuilders.entrySet().iterator().next().getValue().build(record);
    }
}

