/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.connect.common.config;

import io.aiven.kafka.connect.common.config.CompressionType;
import io.aiven.kafka.connect.common.config.FixedSetRecommender;
import io.aiven.kafka.connect.common.config.FormatType;
import io.aiven.kafka.connect.common.config.OutputField;
import io.aiven.kafka.connect.common.config.OutputFieldEncodingType;
import io.aiven.kafka.connect.common.config.OutputFieldType;
import io.aiven.kafka.connect.common.config.TimestampSource;
import io.aiven.kafka.connect.common.config.validators.FileCompressionTypeValidator;
import io.aiven.kafka.connect.common.config.validators.OutputFieldsEncodingValidator;
import io.aiven.kafka.connect.common.config.validators.OutputFieldsValidator;
import io.aiven.kafka.connect.common.config.validators.OutputTypeValidator;
import io.aiven.kafka.connect.common.grouper.RecordGrouperFactory;
import io.aiven.kafka.connect.common.templating.Template;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public class AivenCommonConfig
extends AbstractConfig {
    public static final String FORMAT_OUTPUT_FIELDS_CONFIG = "format.output.fields";
    public static final String FORMAT_OUTPUT_FIELDS_VALUE_ENCODING_CONFIG = "format.output.fields.value.encoding";
    public static final String FORMAT_OUTPUT_TYPE_CONFIG = "format.output.type";
    public static final String FORMAT_OUTPUT_ENVELOPE_CONFIG = "format.output.envelope";
    public static final String FILE_COMPRESSION_TYPE_CONFIG = "file.compression.type";
    public static final String FILE_MAX_RECORDS = "file.max.records";
    public static final String FILE_NAME_TIMESTAMP_TIMEZONE = "file.name.timestamp.timezone";
    public static final String FILE_NAME_TIMESTAMP_SOURCE = "file.name.timestamp.source";
    public static final String FILE_NAME_TEMPLATE_CONFIG = "file.name.template";
    private static final String GROUP_AWS = "AWS";
    private static final String GROUP_FILE = "File";
    private static final String GROUP_FORMAT = "Format";
    private static final String GROUP_COMPRESSION = "File Compression";
    private static final String DEFAULT_FILENAME_TEMPLATE = "{{topic}}-{{partition}}-{{start_offset}}";
    private static final String GROUP_RETRY_BACKOFF_POLICY = "Retry backoff policy";
    public static final String KAFKA_RETRY_BACKOFF_MS_CONFIG = "kafka.retry.backoff.ms";

    protected AivenCommonConfig(ConfigDef definition, Map<?, ?> originals) {
        super(definition, originals);
        this.validate();
    }

    private void validate() {
        List<OutputField> outputFields = this.getOutputFields();
        Boolean outputEnvelopConfig = this.envelopeEnabled();
        if (!outputEnvelopConfig.booleanValue() && outputFields.toArray().length != 1) {
            String msg = String.format("When %s is %s, %s must contain only one field", FORMAT_OUTPUT_ENVELOPE_CONFIG, false, FORMAT_OUTPUT_FIELDS_CONFIG);
            throw new ConfigException(msg);
        }
    }

    protected static void addKafkaBackoffPolicy(ConfigDef configDef) {
        configDef.define(KAFKA_RETRY_BACKOFF_MS_CONFIG, ConfigDef.Type.LONG, null, new ConfigDef.Validator(){
            static final long MAXIMUM_BACKOFF_POLICY = 86400000L;

            public void ensureValid(String name, Object value) {
                if (Objects.isNull(value)) {
                    return;
                }
                assert (value instanceof Long);
                Long longValue = (Long)value;
                if (longValue < 0L) {
                    throw new ConfigException(name, value, "Value must be at least 0");
                }
                if (longValue > 86400000L) {
                    throw new ConfigException(name, value, "Value must be no more than 86400000 (24 hours)");
                }
            }
        }, ConfigDef.Importance.MEDIUM, "The retry backoff in milliseconds. This config is used to notify Kafka Connect to retry delivering a message batch or performing recovery in case of transient exceptions. Maximum value is " + TimeUnit.HOURS.toMillis(24L) + " (24 hours).", GROUP_RETRY_BACKOFF_POLICY, 1, ConfigDef.Width.NONE, KAFKA_RETRY_BACKOFF_MS_CONFIG);
    }

    public Long getKafkaRetryBackoffMs() {
        return this.getLong(KAFKA_RETRY_BACKOFF_MS_CONFIG);
    }

    protected static void addOutputFieldsFormatConfigGroup(ConfigDef configDef, OutputFieldType defaultFieldType) {
        int formatGroupCounter = 0;
        AivenCommonConfig.addFormatTypeConfig(configDef, formatGroupCounter);
        configDef.define(FORMAT_OUTPUT_FIELDS_CONFIG, ConfigDef.Type.LIST, (Object)(!Objects.isNull((Object)defaultFieldType) ? defaultFieldType.name : null), (ConfigDef.Validator)new OutputFieldsValidator(), ConfigDef.Importance.MEDIUM, "Fields to put into output files. The supported values are: " + OutputField.SUPPORTED_OUTPUT_FIELDS + ".", GROUP_FORMAT, formatGroupCounter++, ConfigDef.Width.NONE, FORMAT_OUTPUT_FIELDS_CONFIG, (ConfigDef.Recommender)FixedSetRecommender.ofSupportedValues(OutputFieldType.names()));
        configDef.define(FORMAT_OUTPUT_FIELDS_VALUE_ENCODING_CONFIG, ConfigDef.Type.STRING, (Object)OutputFieldEncodingType.BASE64.name, (ConfigDef.Validator)new OutputFieldsEncodingValidator(), ConfigDef.Importance.MEDIUM, "The type of encoding for the value field. The supported values are: " + OutputFieldEncodingType.SUPPORTED_FIELD_ENCODING_TYPES + ".", GROUP_FORMAT, formatGroupCounter++, ConfigDef.Width.NONE, FORMAT_OUTPUT_FIELDS_VALUE_ENCODING_CONFIG, (ConfigDef.Recommender)FixedSetRecommender.ofSupportedValues(OutputFieldEncodingType.names()));
        configDef.define(FORMAT_OUTPUT_ENVELOPE_CONFIG, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.MEDIUM, "Whether to enable envelope for entries with single field.", GROUP_FORMAT, formatGroupCounter, ConfigDef.Width.SHORT, FORMAT_OUTPUT_ENVELOPE_CONFIG);
    }

    protected static void addFormatTypeConfig(ConfigDef configDef, int formatGroupCounter) {
        String supportedFormatTypes = FormatType.names().stream().map(f -> "'" + f + "'").collect(Collectors.joining(", "));
        configDef.define(FORMAT_OUTPUT_TYPE_CONFIG, ConfigDef.Type.STRING, (Object)FormatType.CSV.name, (ConfigDef.Validator)new OutputTypeValidator(), ConfigDef.Importance.MEDIUM, "The format type of output contentThe supported values are: " + supportedFormatTypes + ".", GROUP_FORMAT, formatGroupCounter, ConfigDef.Width.NONE, FORMAT_OUTPUT_TYPE_CONFIG, (ConfigDef.Recommender)FixedSetRecommender.ofSupportedValues(FormatType.names()));
    }

    public FormatType getFormatType() {
        return FormatType.forName(this.getString(FORMAT_OUTPUT_TYPE_CONFIG));
    }

    protected static void addCompressionTypeConfig(ConfigDef configDef, CompressionType defaultCompressionType) {
        configDef.define(FILE_COMPRESSION_TYPE_CONFIG, ConfigDef.Type.STRING, (Object)(!Objects.isNull((Object)defaultCompressionType) ? defaultCompressionType.name : null), (ConfigDef.Validator)new FileCompressionTypeValidator(), ConfigDef.Importance.MEDIUM, "The compression type used for files put on GCS. The supported values are: " + CompressionType.SUPPORTED_COMPRESSION_TYPES + ".", GROUP_COMPRESSION, 1, ConfigDef.Width.NONE, FILE_COMPRESSION_TYPE_CONFIG, (ConfigDef.Recommender)FixedSetRecommender.ofSupportedValues(CompressionType.names()));
    }

    public CompressionType getCompressionType() {
        return CompressionType.forName(this.getString(FILE_COMPRESSION_TYPE_CONFIG));
    }

    public Boolean envelopeEnabled() {
        return this.getBoolean(FORMAT_OUTPUT_ENVELOPE_CONFIG);
    }

    public OutputFieldEncodingType getOutputFieldEncodingType() {
        return OutputFieldEncodingType.forName(this.getString(FORMAT_OUTPUT_FIELDS_VALUE_ENCODING_CONFIG));
    }

    public final Template getFilenameTemplate() {
        return Template.of(this.getFilename());
    }

    protected final void validateKeyFilenameTemplate() {
        Template filenameTemplate = this.getFilenameTemplate();
        if (RecordGrouperFactory.KEY_RECORD.equals(RecordGrouperFactory.resolveRecordGrouperType(filenameTemplate)) && this.getMaxRecordsPerFile() > 1) {
            String msg = String.format("When %s is %s, %s must be either 1 or not set", FILE_NAME_TEMPLATE_CONFIG, filenameTemplate, FILE_MAX_RECORDS);
            throw new ConfigException(msg);
        }
    }

    public final String getFilename() {
        return this.resolveFilenameTemplate();
    }

    private String resolveFilenameTemplate() {
        Object fileNameTemplate = this.getString(FILE_NAME_TEMPLATE_CONFIG);
        if (fileNameTemplate == null) {
            fileNameTemplate = DEFAULT_FILENAME_TEMPLATE + this.getCompressionType().extension();
        }
        return fileNameTemplate;
    }

    public final ZoneId getFilenameTimezone() {
        return ZoneId.of(this.getString(FILE_NAME_TIMESTAMP_TIMEZONE));
    }

    public final TimestampSource getFilenameTimestampSource() {
        return TimestampSource.of(this.getFilenameTimezone(), TimestampSource.Type.of(this.getString(FILE_NAME_TIMESTAMP_SOURCE)));
    }

    public final int getMaxRecordsPerFile() {
        return this.getInt(FILE_MAX_RECORDS);
    }

    public List<OutputField> getOutputFields() {
        ArrayList<OutputField> result = new ArrayList<OutputField>();
        for (String outputFieldTypeStr : this.getList(FORMAT_OUTPUT_FIELDS_CONFIG)) {
            OutputFieldType fieldType = OutputFieldType.forName(outputFieldTypeStr);
            OutputFieldEncodingType encodingType = fieldType == OutputFieldType.VALUE || fieldType == OutputFieldType.KEY ? this.getOutputFieldEncodingType() : OutputFieldEncodingType.NONE;
            result.add(new OutputField(fieldType, encodingType));
        }
        return result;
    }
}

