/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.connect.common.output.jsonwriter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import io.aiven.kafka.connect.common.output.jsonwriter.OutputFieldBuilder;
import java.io.IOException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import org.apache.kafka.connect.sink.SinkRecord;

class TimestampBuilder
implements OutputFieldBuilder {
    TimestampBuilder() {
    }

    @Override
    public JsonNode build(SinkRecord record) throws IOException {
        Objects.requireNonNull(record, "record cannot be null");
        if (record.timestamp() == null) {
            return null;
        }
        Instant date = Instant.ofEpochMilli(record.timestamp());
        DateTimeFormatter formatter = DateTimeFormatter.ISO_INSTANT;
        String timestampAsISO = formatter.format(date);
        return JsonNodeFactory.instance.textNode(timestampAsISO);
    }
}

