/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.connect.common.output;

import com.github.luben.zstd.ZstdOutputStream;
import io.aiven.kafka.connect.common.config.CompressionType;
import io.aiven.kafka.connect.common.config.FormatType;
import io.aiven.kafka.connect.common.config.OutputField;
import io.aiven.kafka.connect.common.output.OutputStreamWriter;
import io.aiven.kafka.connect.common.output.jsonwriter.JsonLinesOutputWriter;
import io.aiven.kafka.connect.common.output.jsonwriter.JsonOutputWriter;
import io.aiven.kafka.connect.common.output.parquet.ParquetOutputWriter;
import io.aiven.kafka.connect.common.output.plainwriter.PlainOutputWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.zip.GZIPOutputStream;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.sink.SinkRecord;
import org.xerial.snappy.SnappyOutputStream;

public abstract class OutputWriter
implements AutoCloseable {
    private final OutputStreamWriter writer;
    protected final OutputStream outputStream;
    private Boolean isOutputEmpty;
    private Boolean isClosed;
    protected final Map<String, String> externalConfiguration;

    protected OutputWriter(OutputStream outputStream, OutputStreamWriter writer) {
        this(outputStream, writer, Collections.emptyMap());
    }

    protected OutputWriter(OutputStream outputStream, OutputStreamWriter writer, Map<String, String> externalConfiguration) {
        Objects.requireNonNull(writer, "writer");
        Objects.requireNonNull(outputStream, "outputStream");
        this.writer = writer;
        this.outputStream = outputStream;
        this.externalConfiguration = externalConfiguration;
        this.isOutputEmpty = true;
        this.isClosed = false;
    }

    public void writeRecords(Collection<SinkRecord> sinkRecords) throws IOException {
        Objects.requireNonNull(sinkRecords, "sinkRecords");
        if (sinkRecords.isEmpty()) {
            return;
        }
        for (SinkRecord r : sinkRecords) {
            this.writeRecord(r);
        }
    }

    public void writeRecord(SinkRecord record) throws IOException {
        Objects.requireNonNull(record, "record cannot be null");
        if (!this.isOutputEmpty.booleanValue()) {
            this.writer.writeRecordsSeparator(this.outputStream);
        } else {
            this.writer.startWriting(this.outputStream);
            this.isOutputEmpty = false;
        }
        this.writer.writeOneRecord(this.outputStream, record);
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed.booleanValue()) {
            try {
                this.writer.stopWriting(this.outputStream);
                this.outputStream.flush();
            }
            finally {
                if (this.outputStream != null) {
                    this.outputStream.close();
                    this.isClosed = true;
                }
            }
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        protected CompressionType compressionType;
        protected Map<String, String> externalProperties;
        protected Collection<OutputField> outputFields;
        protected boolean envelopeEnabled = true;

        public Builder withCompressionType(CompressionType compressionType) {
            if (Objects.isNull((Object)compressionType)) {
                this.compressionType = CompressionType.NONE;
            }
            this.compressionType = compressionType;
            return this;
        }

        public Builder withExternalProperties(Map<String, String> externalProperties) {
            this.externalProperties = externalProperties;
            return this;
        }

        public Builder withOutputFields(Collection<OutputField> outputFields) {
            this.outputFields = outputFields;
            return this;
        }

        public Builder withEnvelopeEnabled(Boolean enabled) {
            this.envelopeEnabled = enabled;
            return this;
        }

        public OutputWriter build(OutputStream out, FormatType formatType) throws IOException {
            Objects.requireNonNull(this.outputFields, "Output fields haven't been set");
            Objects.requireNonNull(out, "Output stream hasn't been set");
            switch (formatType) {
                case CSV: {
                    return new PlainOutputWriter(this.outputFields, this.getCompressedStream(out));
                }
                case JSONL: {
                    return new JsonLinesOutputWriter(this.outputFields, this.getCompressedStream(out), this.envelopeEnabled);
                }
                case JSON: {
                    return new JsonOutputWriter(this.outputFields, this.getCompressedStream(out), this.envelopeEnabled);
                }
                case PARQUET: {
                    if (Objects.isNull(this.externalProperties)) {
                        this.externalProperties = Collections.emptyMap();
                    }
                    return new ParquetOutputWriter(this.outputFields, out, this.externalProperties, this.envelopeEnabled);
                }
            }
            throw new ConnectException("Unsupported format type " + formatType);
        }

        private OutputStream getCompressedStream(OutputStream outputStream) throws IOException {
            switch (this.compressionType) {
                case ZSTD: {
                    return new ZstdOutputStream(outputStream);
                }
                case GZIP: {
                    return new GZIPOutputStream(outputStream);
                }
                case SNAPPY: {
                    return new SnappyOutputStream(outputStream);
                }
            }
            return outputStream;
        }
    }
}

