/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.connect.common.config;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.apache.kafka.connect.sink.SinkRecord;

public interface TimestampSource {
    public ZonedDateTime time(SinkRecord var1);

    public static TimestampSource of(Type extractorType) {
        return TimestampSource.of(ZoneOffset.UTC, extractorType);
    }

    public static TimestampSource of(ZoneId zoneId, Type extractorType) {
        switch (extractorType) {
            case WALLCLOCK: {
                return new WallclockTimestampSource(zoneId);
            }
            case EVENT: {
                return new EventTimestampSource(zoneId);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported timestamp extractor type: %s", new Object[]{extractorType}));
    }

    public Type type();

    public static final class EventTimestampSource
    implements TimestampSource {
        private final ZoneId zoneId;

        protected EventTimestampSource(ZoneId zoneId) {
            this.zoneId = zoneId;
        }

        @Override
        public ZonedDateTime time(SinkRecord record) {
            LocalDateTime localDateTime = new Timestamp(record.timestamp()).toLocalDateTime();
            return ZonedDateTime.of(localDateTime, this.zoneId);
        }

        @Override
        public Type type() {
            return Type.EVENT;
        }
    }

    public static final class WallclockTimestampSource
    implements TimestampSource {
        private final ZoneId zoneId;

        protected WallclockTimestampSource(ZoneId zoneId) {
            this.zoneId = zoneId;
        }

        @Override
        public ZonedDateTime time(SinkRecord record) {
            return ZonedDateTime.now(this.zoneId);
        }

        @Override
        public Type type() {
            return Type.WALLCLOCK;
        }
    }

    public static enum Type {
        WALLCLOCK,
        EVENT;


        public static Type of(String name) {
            for (Type t : Type.values()) {
                if (!t.name().equalsIgnoreCase(name)) continue;
                return t;
            }
            throw new IllegalArgumentException(String.format("Unknown timestamp source: %s", name));
        }
    }
}

