/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.connect.common.config;

import com.google.common.base.Objects;
import io.aiven.kafka.connect.common.config.OutputFieldEncodingType;
import io.aiven.kafka.connect.common.config.OutputFieldType;
import java.util.stream.Collectors;

public class OutputField {
    public static final String SUPPORTED_OUTPUT_FIELDS = OutputFieldType.names().stream().map(f -> "'" + f + "'").collect(Collectors.joining(", "));
    private OutputFieldType fieldType;
    private OutputFieldEncodingType encodingType;

    public OutputField(OutputFieldType fieldType, OutputFieldEncodingType encodingType) {
        this.fieldType = fieldType;
        this.encodingType = encodingType;
    }

    public OutputFieldType getFieldType() {
        return this.fieldType;
    }

    public OutputFieldEncodingType getEncodingType() {
        return this.encodingType;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.fieldType, this.encodingType});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OutputField)) {
            return false;
        }
        OutputField that = (OutputField)obj;
        return Objects.equal((Object)((Object)this.fieldType), (Object)((Object)that.fieldType)) && Objects.equal((Object)((Object)this.encodingType), (Object)((Object)that.encodingType));
    }
}

