/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.connect.common.templating;

import com.google.common.collect.ImmutableList;
import io.aiven.kafka.connect.common.templating.TemplatePart;
import io.aiven.kafka.connect.common.templating.TextTemplatePart;
import io.aiven.kafka.connect.common.templating.VariableTemplatePart;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TemplateParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplateParser.class);
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\{\\{\\s*([\\w]+)?(:?)([\\w=]+)?\\s*}}");
    private static final Pattern PARAMETER_PATTERN = Pattern.compile("([\\w]+)?=?([\\w]+)?");

    private TemplateParser() {
    }

    public static Pair<List<Pair<String, VariableTemplatePart.Parameter>>, List<TemplatePart>> parse(String template) {
        LOGGER.debug("Parse template: {}", (Object)template);
        ImmutableList.Builder variablesAndParametersBuilder = ImmutableList.builder();
        ImmutableList.Builder templatePartsBuilder = ImmutableList.builder();
        Matcher m = VARIABLE_PATTERN.matcher(template);
        int position = 0;
        while (m.find()) {
            templatePartsBuilder.add((Object)new TextTemplatePart(template.substring(position, m.start())));
            String variable = m.group(1);
            String parameterDef = m.group(2);
            String parameter = m.group(3);
            if (Objects.isNull(variable)) {
                throw new IllegalArgumentException(String.format("Variable name has't been set for template: %s", template));
            }
            if (parameterDef.equals(":") && Objects.isNull(parameter)) {
                throw new IllegalArgumentException("Wrong variable with parameter definition");
            }
            VariableTemplatePart.Parameter p = TemplateParser.parseParameter(variable, parameter);
            variablesAndParametersBuilder.add((Object)Pair.of((Object)variable, (Object)p));
            templatePartsBuilder.add((Object)new VariableTemplatePart(variable, p, m.group()));
            position = m.end();
        }
        templatePartsBuilder.add((Object)new TextTemplatePart(template.substring(position)));
        return Pair.of((Object)variablesAndParametersBuilder.build(), (Object)templatePartsBuilder.build());
    }

    private static VariableTemplatePart.Parameter parseParameter(String variable, String parameter) {
        LOGGER.debug("Parse {} parameter", (Object)parameter);
        if (Objects.nonNull(parameter)) {
            Matcher m = PARAMETER_PATTERN.matcher(parameter);
            if (!m.find()) {
                throw new IllegalArgumentException(String.format("Parameter hasn't been set for variable `%s`", variable));
            }
            String name = m.group(1);
            String value = m.group(2);
            if (Objects.isNull(name)) {
                throw new IllegalArgumentException(String.format("Parameter name for variable `%s` has not been set", variable));
            }
            if (Objects.isNull(value)) {
                throw new IllegalArgumentException(String.format("Parameter value for variable `%s` and parameter `%s` has not been set", variable, name));
            }
            return VariableTemplatePart.Parameter.of(name, value);
        }
        return VariableTemplatePart.Parameter.EMPTY;
    }
}

