/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.connect.common.output.plainwriter;

import io.aiven.kafka.connect.common.output.plainwriter.OutputFieldPlainWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import org.apache.kafka.connect.converters.ByteArrayConverter;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.header.Header;
import org.apache.kafka.connect.sink.SinkRecord;

public class HeadersPlainWriter
implements OutputFieldPlainWriter {
    private static final byte[] HEADER_KEY_VALUE_SEPARATOR = ":".getBytes(StandardCharsets.UTF_8);
    private static final byte[] HEADERS_SEPARATOR = ";".getBytes(StandardCharsets.UTF_8);
    private final ByteArrayConverter byteArrayConverter = new ByteArrayConverter();

    @Override
    public void write(SinkRecord record, OutputStream outputStream) throws IOException {
        Objects.requireNonNull(record, "record cannot be null");
        Objects.requireNonNull(outputStream, "outputStream cannot be null");
        for (Header header : record.headers()) {
            String topic = record.topic();
            String key = header.key();
            Object value = header.value();
            Schema schema = header.schema();
            outputStream.write(Base64.getEncoder().encode(key.getBytes()));
            outputStream.write(HEADER_KEY_VALUE_SEPARATOR);
            byte[] bytes = this.byteArrayConverter.fromConnectHeader(topic, key, schema, value);
            outputStream.write(Base64.getEncoder().encode(bytes));
            outputStream.write(HEADERS_SEPARATOR);
        }
    }
}

