/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.connect.common.output.avro;

import java.util.Map;
import java.util.Objects;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.file.CodecFactory;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

final class AvroConfig
extends AbstractConfig {
    private static final String GROUP_AVRO = "Avro";
    private static final String AVRO_CODEC_CONFIG = "avro.codec";
    private static final String DEFAULT_AVRO_CODEC = "null";

    AvroConfig(ConfigDef configDef, Map<?, ?> originals) {
        super(configDef, originals);
    }

    CodecFactory codecFactory() {
        String codecName = this.originals().getOrDefault(AVRO_CODEC_CONFIG, DEFAULT_AVRO_CODEC).toString();
        return CodecFactory.fromString((String)codecName);
    }

    private static ConfigDef createAvroConfigDefinition() {
        ConfigDef configDef = new ConfigDef();
        configDef.define(AVRO_CODEC_CONFIG, ConfigDef.Type.STRING, (Object)DEFAULT_AVRO_CODEC, (ConfigDef.Validator)new CodecValidator(), ConfigDef.Importance.MEDIUM, "Avro Container File codec.", GROUP_AVRO, 0, ConfigDef.Width.NONE, AVRO_CODEC_CONFIG);
        return configDef;
    }

    public static AvroConfig createAvroConfiguration(Map<?, ?> originals) {
        return new AvroConfig(AvroConfig.createAvroConfigDefinition(), originals);
    }

    private static class CodecValidator
    implements ConfigDef.Validator {
        private CodecValidator() {
        }

        public void ensureValid(String name, Object value) {
            Objects.requireNonNull(name, "Avro codec cannot be null.");
            String proposedCodecName = (String)value;
            if (((String)value).isEmpty()) {
                throw new ConfigException(name, (Object)proposedCodecName, "cannot be empty");
            }
            try {
                CodecFactory.fromString((String)proposedCodecName);
            }
            catch (AvroRuntimeException exception) {
                throw new ConfigException(name, value, "Unknown or not supported codec " + proposedCodecName);
            }
        }
    }
}

