/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.connect.common.grouper;

import io.aiven.kafka.connect.common.config.FilenameTemplateVariable;
import io.aiven.kafka.connect.common.grouper.RecordGrouper;
import io.aiven.kafka.connect.common.templating.Template;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.sink.SinkRecord;

public final class KeyRecordGrouper
implements RecordGrouper {
    private final Template filenameTemplate;
    private final Map<String, List<SinkRecord>> fileBuffers = new HashMap<String, List<SinkRecord>>();

    public KeyRecordGrouper(Template filenameTemplate) {
        Objects.requireNonNull(filenameTemplate, "filenameTemplate cannot be null");
        this.filenameTemplate = filenameTemplate;
    }

    @Override
    public void put(SinkRecord record) {
        Objects.requireNonNull(record, "records cannot be null");
        String recordKey = this.generateRecordKey(record);
        this.fileBuffers.putIfAbsent(recordKey, new ArrayList());
        List<SinkRecord> records = this.fileBuffers.get(recordKey);
        records.clear();
        records.add(record);
    }

    private String generateRecordKey(SinkRecord record) {
        Supplier<String> setKey = () -> {
            if (record.key() == null) {
                return "null";
            }
            if (record.keySchema().type() == Schema.Type.STRING) {
                return (String)record.key();
            }
            return record.key().toString();
        };
        return this.filenameTemplate.instance().bindVariable(FilenameTemplateVariable.KEY.name, setKey).render();
    }

    @Override
    public void clear() {
        this.fileBuffers.clear();
    }

    @Override
    public Map<String, List<SinkRecord>> records() {
        return Collections.unmodifiableMap(this.fileBuffers);
    }
}

