/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.connect.common.output.plainwriter;

import io.aiven.kafka.connect.common.output.OutputStreamWriter;
import io.aiven.kafka.connect.common.output.plainwriter.OutputFieldPlainWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.connect.sink.SinkRecord;

final class PlainOutputStreamWriter
implements OutputStreamWriter {
    private static final byte[] FIELD_SEPARATOR = ",".getBytes(StandardCharsets.UTF_8);
    private static final byte[] RECORD_SEPARATOR = "\n".getBytes(StandardCharsets.UTF_8);
    private final List<OutputFieldPlainWriter> writers;

    PlainOutputStreamWriter(List<OutputFieldPlainWriter> writers) {
        this.writers = writers;
    }

    @Override
    public void writeRecordsSeparator(OutputStream outputStream) throws IOException {
        outputStream.write(RECORD_SEPARATOR);
    }

    @Override
    public void writeOneRecord(OutputStream outputStream, SinkRecord record) throws IOException {
        Iterator<OutputFieldPlainWriter> writerIter = this.writers.iterator();
        writerIter.next().write(record, outputStream);
        while (writerIter.hasNext()) {
            outputStream.write(FIELD_SEPARATOR);
            writerIter.next().write(record, outputStream);
        }
    }
}

