/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.connect.common.output.parquet;

import io.aiven.kafka.connect.common.config.CompressionType;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;

class ParquetConfig
extends AbstractConfig {
    public ParquetConfig(Map<?, ?> originals) {
        super(new ConfigDef(), originals);
    }

    public Configuration parquetConfiguration() {
        Configuration config = new Configuration();
        for (Map.Entry e : this.originalsWithPrefix("connect.").entrySet()) {
            if (!((String)e.getKey()).startsWith("parquet") || ((String)e.getKey()).equals("parquet.avro.schema")) continue;
            config.set((String)e.getKey(), e.getValue().toString());
        }
        return config;
    }

    public CompressionCodecName compressionCodecName() {
        CompressionType connectorCompressionType = CompressionType.forName(this.originals().getOrDefault("file.compression.type", CompressionType.NONE.name).toString());
        switch (connectorCompressionType) {
            case GZIP: {
                return CompressionCodecName.GZIP;
            }
            case SNAPPY: {
                return CompressionCodecName.SNAPPY;
            }
            case ZSTD: {
                return CompressionCodecName.ZSTD;
            }
        }
        return CompressionCodecName.UNCOMPRESSED;
    }
}

