/*
 * Decompiled with CFR 0.152.
 */
package io.aiven.kafka.connect.common.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;

public enum CompressionType {
    NONE("none"){

        @Override
        public String extension() {
            return "";
        }
    }
    ,
    GZIP("gzip"){

        @Override
        public String extension() {
            return ".gz";
        }
    }
    ,
    SNAPPY("snappy"){

        @Override
        public String extension() {
            return ".snappy";
        }
    }
    ,
    ZSTD("zstd"){

        @Override
        public String extension() {
            return ".zst";
        }
    };

    public static final String SUPPORTED_COMPRESSION_TYPES;
    public final String name;

    private CompressionType(String name) {
        this.name = name;
    }

    public static CompressionType forName(String name) {
        Objects.requireNonNull(name, "name cannot be null");
        for (CompressionType ct : CompressionType.values()) {
            if (!ct.name.equalsIgnoreCase(name)) continue;
            return ct;
        }
        throw new IllegalArgumentException("Unknown compression type: " + name);
    }

    public static Collection<String> names() {
        return Arrays.stream(CompressionType.values()).map(v -> v.name).collect(Collectors.toList());
    }

    public abstract String extension();

    static {
        SUPPORTED_COMPRESSION_TYPES = CompressionType.names().stream().map(c -> String.format("'%s'", c)).collect(Collectors.joining(", "));
    }
}

