/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.slice;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import io.airlift.slice.InvalidCodePointException;
import io.airlift.slice.InvalidUtf8Exception;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.Slices;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSliceUtf8 {
    private static final int[] ASCII_CODE_POINTS = IntStream.rangeClosed(0, 127).toArray();
    private static final String STRING_ASCII_CODE_POINTS = new String(ASCII_CODE_POINTS, 0, ASCII_CODE_POINTS.length);
    private static final int[] ALL_CODE_POINTS = IntStream.rangeClosed(0, 0x10FFFF).filter(codePoint -> Character.getType(codePoint) != 19).toArray();
    private static final String STRING_ALL_CODE_POINTS = new String(ALL_CODE_POINTS, 0, ALL_CODE_POINTS.length);
    private static final int[] WHITESPACE_CODE_POINTS = IntStream.rangeClosed(0, 0x10FFFF).filter(Character::isWhitespace).toArray();
    private static final int[] ALL_CODE_POINTS_RANDOM = Arrays.copyOf(ALL_CODE_POINTS, ALL_CODE_POINTS.length);
    private static final String STRING_ALL_CODE_POINTS_RANDOM;
    private static final byte START_1_BYTE = 127;
    private static final byte CONTINUATION_BYTE = -65;
    private static final byte START_2_BYTE = -33;
    private static final byte START_3_BYTE = -17;
    private static final byte START_4_BYTE = -9;
    private static final byte START_5_BYTE = -5;
    private static final byte START_6_BYTE = -3;
    private static final byte INVALID_FE_BYTE = -2;
    private static final byte INVALID_FF_BYTE = -1;
    private static final byte X_CHAR = 88;
    private static final List<byte[]> INVALID_SEQUENCES;
    private static final String STRING_EMPTY = "";
    private static final String STRING_HELLO = "hello";
    private static final String STRING_QUADRATICALLY = "Quadratically";
    private static final String STRING_OESTERREICH = "\u00d6sterreich";
    private static final String STRING_DULIOE_DULIOE = "Duli\u00f6 duli\u00f6";
    private static final String STRING_FAITH_HOPE_LOVE = "\u4fe1\u5ff5,\u7231,\u5e0c\u671b";
    private static final String STRING_NAIVE = "na\u00efve";
    private static final String STRING_OO = "\ud801\udc2dend";
    private static final byte[] INVALID_SEQUENCE_TO_LOWER_EXPANDS;
    private static final byte[] INVALID_UTF8_1;
    private static final byte[] INVALID_UTF8_2;
    private static final byte[] EM_SPACE_SURROUNDED_BY_CONTINUATION_BYTE;

    @Test
    public void testCodePointCount() {
        TestSliceUtf8.assertCodePointCount(STRING_EMPTY);
        TestSliceUtf8.assertCodePointCount(STRING_HELLO);
        TestSliceUtf8.assertCodePointCount(STRING_QUADRATICALLY);
        TestSliceUtf8.assertCodePointCount(STRING_OESTERREICH);
        TestSliceUtf8.assertCodePointCount(STRING_DULIOE_DULIOE);
        TestSliceUtf8.assertCodePointCount(STRING_FAITH_HOPE_LOVE);
        TestSliceUtf8.assertCodePointCount(STRING_NAIVE);
        TestSliceUtf8.assertCodePointCount(STRING_OO);
        TestSliceUtf8.assertCodePointCount(STRING_ASCII_CODE_POINTS);
        TestSliceUtf8.assertCodePointCount(STRING_ALL_CODE_POINTS);
        TestSliceUtf8.assertCodePointCount(STRING_ALL_CODE_POINTS_RANDOM);
        Assert.assertEquals((int)SliceUtf8.countCodePoints((Slice)Slices.wrappedBuffer((byte[])new byte[]{127})), (int)1);
        Assert.assertEquals((int)SliceUtf8.countCodePoints((Slice)Slices.wrappedBuffer((byte[])new byte[]{-33})), (int)1);
        Assert.assertEquals((int)SliceUtf8.countCodePoints((Slice)Slices.wrappedBuffer((byte[])new byte[]{-17})), (int)1);
        Assert.assertEquals((int)SliceUtf8.countCodePoints((Slice)Slices.wrappedBuffer((byte[])new byte[]{-9})), (int)1);
        Assert.assertEquals((int)SliceUtf8.countCodePoints((Slice)Slices.wrappedBuffer((byte[])new byte[]{-5})), (int)1);
        Assert.assertEquals((int)SliceUtf8.countCodePoints((Slice)Slices.wrappedBuffer((byte[])new byte[]{-3})), (int)1);
        Assert.assertEquals((int)SliceUtf8.countCodePoints((Slice)Slices.wrappedBuffer((byte[])new byte[]{-2})), (int)1);
        Assert.assertEquals((int)SliceUtf8.countCodePoints((Slice)Slices.wrappedBuffer((byte[])new byte[]{-1})), (int)1);
        Assert.assertEquals((int)SliceUtf8.countCodePoints((Slice)Slices.wrappedBuffer((byte[])new byte[]{-65})), (int)0);
    }

    private static void assertCodePointCount(String string) {
        Assert.assertEquals((long)SliceUtf8.countCodePoints((Slice)Slices.utf8Slice((String)string)), (long)string.codePoints().count());
    }

    @Test
    public void testOffsetByCodePoints() {
        Assert.assertEquals((int)SliceUtf8.offsetOfCodePoint((Slice)Slices.EMPTY_SLICE, (int)0), (int)-1);
        TestSliceUtf8.assertOffsetByCodePoints(STRING_HELLO);
        TestSliceUtf8.assertOffsetByCodePoints(STRING_QUADRATICALLY);
        TestSliceUtf8.assertOffsetByCodePoints(STRING_OESTERREICH);
        TestSliceUtf8.assertOffsetByCodePoints(STRING_DULIOE_DULIOE);
        TestSliceUtf8.assertOffsetByCodePoints(STRING_FAITH_HOPE_LOVE);
        TestSliceUtf8.assertOffsetByCodePoints(STRING_NAIVE);
        TestSliceUtf8.assertOffsetByCodePoints(STRING_OO);
        TestSliceUtf8.assertOffsetByCodePoints(STRING_ASCII_CODE_POINTS);
        TestSliceUtf8.assertOffsetByCodePoints(STRING_ALL_CODE_POINTS);
        TestSliceUtf8.assertOffsetByCodePoints(STRING_ALL_CODE_POINTS_RANDOM);
    }

    private static void assertOffsetByCodePoints(String string) {
        Slice utf8 = Slices.utf8Slice((String)string);
        int codePoints = (int)string.codePoints().count();
        int lastIndex = 0;
        int characterIndex = 0;
        for (int codePointIndex = 0; codePointIndex < codePoints; ++codePointIndex) {
            int expectedIndex = 0;
            if (codePointIndex > 0) {
                expectedIndex = lastIndex + SliceUtf8.lengthOfCodePoint((int)string.codePointAt(characterIndex));
                characterIndex = string.offsetByCodePoints(characterIndex, 1);
            }
            if (codePointIndex < 10000) {
                Assert.assertEquals((int)SliceUtf8.offsetOfCodePoint((Slice)utf8, (int)codePointIndex), (int)expectedIndex);
            }
            if (codePointIndex > 0) {
                Assert.assertEquals((int)SliceUtf8.offsetOfCodePoint((Slice)utf8, (int)lastIndex, (int)1), (int)expectedIndex);
            }
            lastIndex = expectedIndex;
        }
        Assert.assertEquals((int)SliceUtf8.offsetOfCodePoint((Slice)Slices.utf8Slice((String)string), (int)codePoints), (int)-1);
    }

    @Test
    public void testSubstring() {
        TestSliceUtf8.assertSubstring(STRING_HELLO);
        TestSliceUtf8.assertSubstring(STRING_QUADRATICALLY);
        TestSliceUtf8.assertSubstring(STRING_OESTERREICH);
        TestSliceUtf8.assertSubstring(STRING_DULIOE_DULIOE);
        TestSliceUtf8.assertSubstring(STRING_FAITH_HOPE_LOVE);
        TestSliceUtf8.assertSubstring(STRING_NAIVE);
        TestSliceUtf8.assertSubstring(STRING_OO);
        TestSliceUtf8.assertSubstring(STRING_ASCII_CODE_POINTS);
        TestSliceUtf8.assertSubstring(new String(ALL_CODE_POINTS, ALL_CODE_POINTS.length - 500, 500));
    }

    private static void assertSubstring(String string) {
        Slice utf8 = Slices.utf8Slice((String)string);
        int[] codePoints = string.codePoints().toArray();
        for (int start = 0; start < codePoints.length / 2; ++start) {
            int count = Math.min(20, codePoints.length - start - start - 1);
            Slice actual = SliceUtf8.substring((Slice)utf8, (int)start, (int)count);
            Slice expected = Slices.wrappedBuffer((byte[])new String(codePoints, start, count).getBytes(StandardCharsets.UTF_8));
            Assert.assertEquals((Object)actual, (Object)expected);
        }
        Assert.assertEquals((Object)SliceUtf8.substring((Slice)utf8, (int)0, (int)codePoints.length), (Object)utf8);
        Assert.assertEquals((Object)SliceUtf8.substring((Slice)utf8, (int)0, (int)0), (Object)Slices.EMPTY_SLICE);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="UTF-8 does not contain 10 code points")
    public void testSubstringInvalidStart() {
        SliceUtf8.substring((Slice)Slices.utf8Slice((String)STRING_HELLO), (int)10, (int)2);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="UTF-8 does not contain 7 code points")
    public void testSubstringInvalidLength() {
        SliceUtf8.substring((Slice)Slices.utf8Slice((String)STRING_HELLO), (int)0, (int)7);
    }

    @Test(expectedExceptions={InvalidUtf8Exception.class}, expectedExceptionsMessageRegExp="UTF-8 is not well formed")
    public void testSubstringInvalidUtf8() {
        SliceUtf8.substring((Slice)Slices.wrappedBuffer((byte[])new byte[]{102, 111, 111, -17, -65}), (int)0, (int)4);
    }

    @Test
    public void testReverse() {
        TestSliceUtf8.assertReverse(STRING_HELLO);
        TestSliceUtf8.assertReverse(STRING_QUADRATICALLY);
        TestSliceUtf8.assertReverse(STRING_OESTERREICH);
        TestSliceUtf8.assertReverse(STRING_DULIOE_DULIOE);
        TestSliceUtf8.assertReverse(STRING_FAITH_HOPE_LOVE);
        TestSliceUtf8.assertReverse(STRING_NAIVE);
        TestSliceUtf8.assertReverse(STRING_OO);
        TestSliceUtf8.assertReverse(STRING_ASCII_CODE_POINTS);
        TestSliceUtf8.assertReverse(STRING_ALL_CODE_POINTS);
        INVALID_SEQUENCES.forEach(TestSliceUtf8::assertReverseWithInvalidSequence);
    }

    private static void assertReverse(String string) {
        Slice actualReverse = SliceUtf8.reverse((Slice)Slices.utf8Slice((String)string));
        int[] codePoints = string.codePoints().toArray();
        codePoints = Ints.toArray((Collection)Lists.reverse((List)Ints.asList((int[])codePoints)));
        Slice expectedReverse = Slices.wrappedBuffer((byte[])new String(codePoints, 0, codePoints.length).getBytes(StandardCharsets.UTF_8));
        Assert.assertEquals((Object)actualReverse, (Object)expectedReverse);
    }

    private static void assertReverseWithInvalidSequence(byte[] invalidSequence) {
        Assert.assertEquals((Object)SliceUtf8.reverse((Slice)Slices.wrappedBuffer((byte[])invalidSequence)), (Object)Slices.wrappedBuffer((byte[])invalidSequence));
        Assert.assertEquals((Object)SliceUtf8.reverse((Slice)Slices.wrappedBuffer((byte[])Bytes.concat((byte[][])new byte[][]{{97, 98, 99}, invalidSequence}))), (Object)Slices.wrappedBuffer((byte[])Bytes.concat((byte[][])new byte[][]{invalidSequence, {99, 98, 97}})));
        Assert.assertEquals((Object)SliceUtf8.reverse((Slice)Slices.wrappedBuffer((byte[])Bytes.concat((byte[][])new byte[][]{invalidSequence, {120, 121, 122}}))), (Object)Slices.wrappedBuffer((byte[])Bytes.concat((byte[][])new byte[][]{{122, 121, 120}, invalidSequence})));
        Assert.assertEquals((Object)SliceUtf8.reverse((Slice)Slices.wrappedBuffer((byte[])Bytes.concat((byte[][])new byte[][]{{97, 98, 99}, invalidSequence, {120, 121, 122}}))), (Object)Slices.wrappedBuffer((byte[])Bytes.concat((byte[][])new byte[][]{{122, 121, 120}, invalidSequence, {99, 98, 97}})));
    }

    @Test
    public void testIsAscii() {
        Assert.assertTrue((boolean)SliceUtf8.isAscii((Slice)Slices.utf8Slice((String)STRING_HELLO)));
        Assert.assertTrue((boolean)SliceUtf8.isAscii((Slice)Slices.utf8Slice((String)STRING_QUADRATICALLY)));
        Assert.assertFalse((boolean)SliceUtf8.isAscii((Slice)Slices.utf8Slice((String)STRING_OESTERREICH)));
        Assert.assertFalse((boolean)SliceUtf8.isAscii((Slice)Slices.utf8Slice((String)STRING_DULIOE_DULIOE)));
        Assert.assertFalse((boolean)SliceUtf8.isAscii((Slice)Slices.utf8Slice((String)STRING_FAITH_HOPE_LOVE)));
        Assert.assertFalse((boolean)SliceUtf8.isAscii((Slice)Slices.utf8Slice((String)STRING_NAIVE)));
        Assert.assertFalse((boolean)SliceUtf8.isAscii((Slice)Slices.utf8Slice((String)STRING_OO)));
        Assert.assertTrue((boolean)SliceUtf8.isAscii((Slice)Slices.utf8Slice((String)STRING_ASCII_CODE_POINTS)));
        Assert.assertFalse((boolean)SliceUtf8.isAscii((Slice)Slices.utf8Slice((String)STRING_ALL_CODE_POINTS)));
    }

    @Test
    public void testFixInvalidUtf8() {
        TestSliceUtf8.assertFixInvalidUtf8(Slices.utf8Slice((String)STRING_OESTERREICH), Slices.utf8Slice((String)STRING_OESTERREICH));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.utf8Slice((String)STRING_HELLO), Slices.utf8Slice((String)STRING_HELLO));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.utf8Slice((String)STRING_QUADRATICALLY), Slices.utf8Slice((String)STRING_QUADRATICALLY));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.utf8Slice((String)STRING_OESTERREICH), Slices.utf8Slice((String)STRING_OESTERREICH));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.utf8Slice((String)STRING_DULIOE_DULIOE), Slices.utf8Slice((String)STRING_DULIOE_DULIOE));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.utf8Slice((String)STRING_FAITH_HOPE_LOVE), Slices.utf8Slice((String)STRING_FAITH_HOPE_LOVE));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.utf8Slice((String)STRING_NAIVE), Slices.utf8Slice((String)STRING_NAIVE));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.utf8Slice((String)STRING_OO), Slices.utf8Slice((String)STRING_OO));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.utf8Slice((String)STRING_ASCII_CODE_POINTS), Slices.utf8Slice((String)STRING_ASCII_CODE_POINTS));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.utf8Slice((String)STRING_ALL_CODE_POINTS), Slices.utf8Slice((String)STRING_ALL_CODE_POINTS));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.wrappedBuffer((byte[])new byte[]{88, -33, -65}), Slices.utf8Slice((String)"X\u07ff"));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.wrappedBuffer((byte[])new byte[]{88, -17, -65, -65}), Slices.utf8Slice((String)"X\uffff"));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.wrappedBuffer((byte[])new byte[]{88, -12, -113, -65, -65}), Slices.wrappedBuffer((byte[])new byte[]{88, -12, -113, -65, -65}));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.wrappedBuffer((byte[])new byte[]{88, -9, -65, -65, -65}), Slices.utf8Slice((String)"X\ufffd"));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.wrappedBuffer((byte[])new byte[]{88, -5, -65, -65, -65, -65}), Slices.utf8Slice((String)"X\ufffd"));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.wrappedBuffer((byte[])new byte[]{88, -3, -65, -65, -65, -65, -65}), Slices.utf8Slice((String)"X\ufffd"));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.wrappedBuffer((byte[])new byte[]{88, -65}), Slices.utf8Slice((String)"X\ufffd"));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.wrappedBuffer((byte[])new byte[]{88, -2}), Slices.utf8Slice((String)"X\ufffd"));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.wrappedBuffer((byte[])new byte[]{88, -1}), Slices.utf8Slice((String)"X\ufffd"));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.wrappedBuffer((byte[])new byte[]{88, -33, 88}), Slices.utf8Slice((String)"X\ufffdX"));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.wrappedBuffer((byte[])new byte[]{88, -17, 88, 88}), Slices.utf8Slice((String)"X\ufffdXX"));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.wrappedBuffer((byte[])new byte[]{88, -17, -65, 88}), Slices.utf8Slice((String)"X\ufffdX"));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.wrappedBuffer((byte[])new byte[]{88, -9, 88, 88, 88}), Slices.utf8Slice((String)"X\ufffdXXX"));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.wrappedBuffer((byte[])new byte[]{88, -9, -65, 88, 88}), Slices.utf8Slice((String)"X\ufffdXX"));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.wrappedBuffer((byte[])new byte[]{88, -9, -65, -65, 88}), Slices.utf8Slice((String)"X\ufffdX"));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.wrappedBuffer((byte[])new byte[]{88, -5, 88, 88, 88, 88}), Slices.utf8Slice((String)"X\ufffdXXXX"));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.wrappedBuffer((byte[])new byte[]{88, -5, -65, 88, 88, 88}), Slices.utf8Slice((String)"X\ufffdXXX"));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.wrappedBuffer((byte[])new byte[]{88, -5, -65, -65, 88, 88}), Slices.utf8Slice((String)"X\ufffdXX"));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.wrappedBuffer((byte[])new byte[]{88, -5, -65, -65, -65, 88}), Slices.utf8Slice((String)"X\ufffdX"));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.wrappedBuffer((byte[])new byte[]{88, -3, 88, 88, 88, 88, 88}), Slices.utf8Slice((String)"X\ufffdXXXXX"));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.wrappedBuffer((byte[])new byte[]{88, -3, -65, 88, 88, 88, 88}), Slices.utf8Slice((String)"X\ufffdXXXX"));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.wrappedBuffer((byte[])new byte[]{88, -3, -65, -65, 88, 88, 88}), Slices.utf8Slice((String)"X\ufffdXXX"));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.wrappedBuffer((byte[])new byte[]{88, -3, -65, -65, -65, 88, 88}), Slices.utf8Slice((String)"X\ufffdXX"));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.wrappedBuffer((byte[])new byte[]{88, -3, -65, -65, -65, -65, 88}), Slices.utf8Slice((String)"X\ufffdX"));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.wrappedBuffer((byte[])new byte[]{88, -2}), Slices.utf8Slice((String)"X\ufffd"));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.wrappedBuffer((byte[])new byte[]{88, -1}), Slices.utf8Slice((String)"X\ufffd"));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.wrappedBuffer((byte[])new byte[]{88, -65}), Slices.utf8Slice((String)"X\ufffd"));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.wrappedBuffer((byte[])new byte[]{88, -33}), Slices.utf8Slice((String)"X\ufffd"));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.wrappedBuffer((byte[])new byte[]{88, -17}), Slices.utf8Slice((String)"X\ufffd"));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.wrappedBuffer((byte[])new byte[]{88, -17, -65}), Slices.utf8Slice((String)"X\ufffd"));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.wrappedBuffer((byte[])new byte[]{88, -9}), Slices.utf8Slice((String)"X\ufffd"));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.wrappedBuffer((byte[])new byte[]{88, -9, -65}), Slices.utf8Slice((String)"X\ufffd"));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.wrappedBuffer((byte[])new byte[]{88, -9, -65, -65}), Slices.utf8Slice((String)"X\ufffd"));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.wrappedBuffer((byte[])new byte[]{88, -5}), Slices.utf8Slice((String)"X\ufffd"));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.wrappedBuffer((byte[])new byte[]{88, -5, -65}), Slices.utf8Slice((String)"X\ufffd"));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.wrappedBuffer((byte[])new byte[]{88, -5, -65, -65}), Slices.utf8Slice((String)"X\ufffd"));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.wrappedBuffer((byte[])new byte[]{88, -5, -65, -65, -65}), Slices.utf8Slice((String)"X\ufffd"));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.wrappedBuffer((byte[])new byte[]{88, -3}), Slices.utf8Slice((String)"X\ufffd"));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.wrappedBuffer((byte[])new byte[]{88, -3, -65}), Slices.utf8Slice((String)"X\ufffd"));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.wrappedBuffer((byte[])new byte[]{88, -3, -65, -65}), Slices.utf8Slice((String)"X\ufffd"));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.wrappedBuffer((byte[])new byte[]{88, -3, -65, -65, -65}), Slices.utf8Slice((String)"X\ufffd"));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.wrappedBuffer((byte[])new byte[]{88, -3, -65, -65, -65, -65}), Slices.utf8Slice((String)"X\ufffd"));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.wrappedBuffer((byte[])new byte[]{88, -3, -65, -65, -65, -65, -65}), Slices.utf8Slice((String)"X\ufffd"));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.wrappedBuffer((byte[])new byte[]{88, -2}), Slices.utf8Slice((String)"X\ufffd"));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.wrappedBuffer((byte[])new byte[]{88, -1}), Slices.utf8Slice((String)"X\ufffd"));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.wrappedBuffer((byte[])new byte[]{88, -19, -96, -128}), Slices.utf8Slice((String)"X\ufffd"));
        TestSliceUtf8.assertFixInvalidUtf8(Slices.wrappedBuffer((byte[])new byte[]{88, -19, -65, -65}), Slices.utf8Slice((String)"X\ufffd"));
    }

    private static void assertFixInvalidUtf8(Slice testSlice, Slice expectedSlice) {
        Assert.assertEquals((Object)SliceUtf8.fixInvalidUtf8((Slice)testSlice), (Object)expectedSlice);
    }

    @Test
    public void testCaseChange() {
        TestSliceUtf8.assertCaseChange(STRING_ALL_CODE_POINTS);
        TestSliceUtf8.assertCaseChange(STRING_FAITH_HOPE_LOVE);
        TestSliceUtf8.assertCaseChange(STRING_HELLO);
        TestSliceUtf8.assertCaseChange(STRING_QUADRATICALLY);
        TestSliceUtf8.assertCaseChange(STRING_OESTERREICH);
        TestSliceUtf8.assertCaseChange(STRING_DULIOE_DULIOE);
        TestSliceUtf8.assertCaseChange(STRING_FAITH_HOPE_LOVE);
        TestSliceUtf8.assertCaseChange(STRING_NAIVE);
        TestSliceUtf8.assertCaseChange(STRING_OO);
        TestSliceUtf8.assertCaseChange(STRING_ASCII_CODE_POINTS);
        TestSliceUtf8.assertCaseChange(STRING_ALL_CODE_POINTS);
        TestSliceUtf8.assertCaseChange(STRING_ALL_CODE_POINTS_RANDOM);
        SliceUtf8.toLowerCase((Slice)Slices.wrappedBuffer((byte[])INVALID_SEQUENCE_TO_LOWER_EXPANDS));
        INVALID_SEQUENCES.forEach(TestSliceUtf8::assertCaseChangeWithInvalidSequence);
    }

    private static void assertCaseChangeWithInvalidSequence(byte[] invalidSequence) {
        Assert.assertEquals((Object)SliceUtf8.toLowerCase((Slice)Slices.wrappedBuffer((byte[])invalidSequence)), (Object)Slices.wrappedBuffer((byte[])invalidSequence));
        Assert.assertEquals((Object)SliceUtf8.toUpperCase((Slice)Slices.wrappedBuffer((byte[])invalidSequence)), (Object)Slices.wrappedBuffer((byte[])invalidSequence));
        Assert.assertEquals((Object)SliceUtf8.toLowerCase((Slice)Slices.wrappedBuffer((byte[])Bytes.concat((byte[][])new byte[][]{{70, 79, 79}, invalidSequence}))), (Object)Slices.wrappedBuffer((byte[])Bytes.concat((byte[][])new byte[][]{{102, 111, 111}, invalidSequence})));
        Assert.assertEquals((Object)SliceUtf8.toUpperCase((Slice)Slices.wrappedBuffer((byte[])Bytes.concat((byte[][])new byte[][]{{102, 111, 111}, invalidSequence}))), (Object)Slices.wrappedBuffer((byte[])Bytes.concat((byte[][])new byte[][]{{70, 79, 79}, invalidSequence})));
        Assert.assertEquals((Object)SliceUtf8.toLowerCase((Slice)Slices.wrappedBuffer((byte[])Bytes.concat((byte[][])new byte[][]{invalidSequence, {70, 79, 79}}))), (Object)Slices.wrappedBuffer((byte[])Bytes.concat((byte[][])new byte[][]{invalidSequence, {102, 111, 111}})));
        Assert.assertEquals((Object)SliceUtf8.toUpperCase((Slice)Slices.wrappedBuffer((byte[])Bytes.concat((byte[][])new byte[][]{invalidSequence, {102, 111, 111}}))), (Object)Slices.wrappedBuffer((byte[])Bytes.concat((byte[][])new byte[][]{invalidSequence, {70, 79, 79}})));
        Assert.assertEquals((Object)SliceUtf8.toLowerCase((Slice)Slices.wrappedBuffer((byte[])Bytes.concat((byte[][])new byte[][]{{70, 79, 79}, invalidSequence, {66, 65, 82}}))), (Object)Slices.wrappedBuffer((byte[])Bytes.concat((byte[][])new byte[][]{{102, 111, 111}, invalidSequence, {98, 97, 114}})));
        Assert.assertEquals((Object)SliceUtf8.toUpperCase((Slice)Slices.wrappedBuffer((byte[])Bytes.concat((byte[][])new byte[][]{{102, 111, 111}, invalidSequence, {98, 97, 114}}))), (Object)Slices.wrappedBuffer((byte[])Bytes.concat((byte[][])new byte[][]{{70, 79, 79}, invalidSequence, {66, 65, 82}})));
    }

    private static void assertCaseChange(String string) {
        String expectedLower = TestSliceUtf8.lowerByCodePoint(string);
        Slice actualLower = SliceUtf8.toLowerCase((Slice)Slices.utf8Slice((String)string));
        Assert.assertEquals((Object)actualLower, (Object)Slices.wrappedBuffer((byte[])expectedLower.getBytes(StandardCharsets.UTF_8)));
        String expectedUpper = TestSliceUtf8.upperByCodePoint(string);
        Slice actualUpper = SliceUtf8.toUpperCase((Slice)Slices.utf8Slice((String)string));
        Assert.assertEquals((Object)actualUpper, (Object)Slices.wrappedBuffer((byte[])expectedUpper.getBytes(StandardCharsets.UTF_8)));
        Assert.assertEquals((Object)SliceUtf8.toLowerCase((Slice)actualUpper), (Object)Slices.wrappedBuffer((byte[])TestSliceUtf8.lowerByCodePoint(expectedUpper).getBytes(StandardCharsets.UTF_8)));
        Assert.assertEquals((Object)SliceUtf8.toUpperCase((Slice)actualLower), (Object)Slices.wrappedBuffer((byte[])TestSliceUtf8.upperByCodePoint(expectedLower).getBytes(StandardCharsets.UTF_8)));
    }

    private static String lowerByCodePoint(String string) {
        int[] upperCodePoints = string.codePoints().map(Character::toLowerCase).toArray();
        return new String(upperCodePoints, 0, upperCodePoints.length);
    }

    private static String upperByCodePoint(String string) {
        int[] upperCodePoints = string.codePoints().map(Character::toUpperCase).toArray();
        return new String(upperCodePoints, 0, upperCodePoints.length);
    }

    @Test
    public void testLeftTrim() {
        TestSliceUtf8.assertLeftTrim(STRING_EMPTY);
        TestSliceUtf8.assertLeftTrim(STRING_HELLO);
        TestSliceUtf8.assertLeftTrim("hello world");
        TestSliceUtf8.assertLeftTrim("hello world  ");
        TestSliceUtf8.assertLeftTrim(EM_SPACE_SURROUNDED_BY_CONTINUATION_BYTE);
        INVALID_SEQUENCES.forEach(TestSliceUtf8::assertLeftTrim);
    }

    private static void assertLeftTrim(String string) {
        TestSliceUtf8.assertLeftTrim(string.getBytes(StandardCharsets.UTF_8));
    }

    private static void assertLeftTrim(byte[] sequence) {
        Assert.assertEquals((Object)SliceUtf8.leftTrim((Slice)Slices.wrappedBuffer((byte[])sequence)), (Object)Slices.wrappedBuffer((byte[])sequence));
        Assert.assertEquals((Object)SliceUtf8.leftTrim((Slice)Slices.wrappedBuffer((byte[])sequence), (int[])WHITESPACE_CODE_POINTS), (Object)Slices.wrappedBuffer((byte[])sequence));
        Assert.assertEquals((Object)SliceUtf8.leftTrim((Slice)Slices.wrappedBuffer((byte[])Bytes.concat((byte[][])new byte[][]{{64}, sequence})), (int[])new int[]{64}), (Object)Slices.wrappedBuffer((byte[])sequence));
        for (int codePoint : ALL_CODE_POINTS) {
            if (!Character.isWhitespace(codePoint)) continue;
            byte[] whitespace = new String(new int[]{codePoint}, 0, 1).getBytes(StandardCharsets.UTF_8);
            Assert.assertEquals((Object)SliceUtf8.leftTrim((Slice)Slices.wrappedBuffer((byte[])Bytes.concat((byte[][])new byte[][]{whitespace, sequence}))), (Object)Slices.wrappedBuffer((byte[])sequence));
            Assert.assertEquals((Object)SliceUtf8.leftTrim((Slice)Slices.wrappedBuffer((byte[])Bytes.concat((byte[][])new byte[][]{whitespace, sequence})), (int[])WHITESPACE_CODE_POINTS), (Object)Slices.wrappedBuffer((byte[])sequence));
            Assert.assertEquals((Object)SliceUtf8.leftTrim((Slice)Slices.wrappedBuffer((byte[])Bytes.concat((byte[][])new byte[][]{whitespace, {13, 10, 9, 32}, whitespace, sequence})), (int[])WHITESPACE_CODE_POINTS), (Object)Slices.wrappedBuffer((byte[])sequence));
        }
    }

    @Test
    public void testRightTrim() {
        TestSliceUtf8.assertRightTrim(STRING_EMPTY);
        TestSliceUtf8.assertRightTrim(STRING_HELLO);
        TestSliceUtf8.assertRightTrim("hello world");
        TestSliceUtf8.assertRightTrim("  hello world");
        TestSliceUtf8.assertRightTrim(EM_SPACE_SURROUNDED_BY_CONTINUATION_BYTE);
        INVALID_SEQUENCES.forEach(TestSliceUtf8::assertRightTrim);
    }

    private static void assertRightTrim(String string) {
        TestSliceUtf8.assertRightTrim(string.getBytes(StandardCharsets.UTF_8));
    }

    private static void assertRightTrim(byte[] sequence) {
        Assert.assertEquals((Object)SliceUtf8.rightTrim((Slice)Slices.wrappedBuffer((byte[])sequence)), (Object)Slices.wrappedBuffer((byte[])sequence));
        Assert.assertEquals((Object)SliceUtf8.rightTrim((Slice)Slices.wrappedBuffer((byte[])sequence), (int[])WHITESPACE_CODE_POINTS), (Object)Slices.wrappedBuffer((byte[])sequence));
        Assert.assertEquals((Object)SliceUtf8.rightTrim((Slice)Slices.wrappedBuffer((byte[])Bytes.concat((byte[][])new byte[][]{sequence, {64}})), (int[])new int[]{64}), (Object)Slices.wrappedBuffer((byte[])sequence));
        for (int codePoint : ALL_CODE_POINTS) {
            if (!Character.isWhitespace(codePoint)) continue;
            byte[] whitespace = new String(new int[]{codePoint}, 0, 1).getBytes(StandardCharsets.UTF_8);
            Assert.assertEquals((Object)SliceUtf8.rightTrim((Slice)Slices.wrappedBuffer((byte[])Bytes.concat((byte[][])new byte[][]{sequence, whitespace}))), (Object)Slices.wrappedBuffer((byte[])sequence));
            Assert.assertEquals((Object)SliceUtf8.rightTrim((Slice)Slices.wrappedBuffer((byte[])Bytes.concat((byte[][])new byte[][]{sequence, whitespace})), (int[])WHITESPACE_CODE_POINTS), (Object)Slices.wrappedBuffer((byte[])sequence));
            Assert.assertEquals((Object)SliceUtf8.rightTrim((Slice)Slices.wrappedBuffer((byte[])Bytes.concat((byte[][])new byte[][]{sequence, whitespace, {13, 10, 9, 32}, whitespace}))), (Object)Slices.wrappedBuffer((byte[])sequence));
            Assert.assertEquals((Object)SliceUtf8.rightTrim((Slice)Slices.wrappedBuffer((byte[])Bytes.concat((byte[][])new byte[][]{sequence, whitespace, {13, 10, 9, 32}, whitespace})), (int[])WHITESPACE_CODE_POINTS), (Object)Slices.wrappedBuffer((byte[])sequence));
        }
    }

    @Test
    public void testTrim() {
        TestSliceUtf8.assertTrim(STRING_EMPTY);
        TestSliceUtf8.assertTrim(STRING_HELLO);
        TestSliceUtf8.assertTrim("hello world");
        TestSliceUtf8.assertTrim(EM_SPACE_SURROUNDED_BY_CONTINUATION_BYTE);
        INVALID_SEQUENCES.forEach(TestSliceUtf8::assertTrim);
    }

    private static void assertTrim(String string) {
        TestSliceUtf8.assertTrim(string.getBytes(StandardCharsets.UTF_8));
    }

    private static void assertTrim(byte[] sequence) {
        Assert.assertEquals((Object)SliceUtf8.trim((Slice)Slices.wrappedBuffer((byte[])sequence)), (Object)Slices.wrappedBuffer((byte[])sequence));
        Assert.assertEquals((Object)SliceUtf8.trim((Slice)Slices.wrappedBuffer((byte[])sequence), (int[])WHITESPACE_CODE_POINTS), (Object)Slices.wrappedBuffer((byte[])sequence));
        Assert.assertEquals((Object)SliceUtf8.trim((Slice)Slices.wrappedBuffer((byte[])Bytes.concat((byte[][])new byte[][]{{64}, sequence, {64}})), (int[])new int[]{64}), (Object)Slices.wrappedBuffer((byte[])sequence));
        for (int codePoint : ALL_CODE_POINTS) {
            if (!Character.isWhitespace(codePoint)) continue;
            byte[] whitespace = new String(new int[]{codePoint}, 0, 1).getBytes(StandardCharsets.UTF_8);
            Assert.assertEquals((Object)SliceUtf8.trim((Slice)Slices.wrappedBuffer((byte[])Bytes.concat((byte[][])new byte[][]{whitespace, sequence, whitespace}))), (Object)Slices.wrappedBuffer((byte[])sequence));
            Assert.assertEquals((Object)SliceUtf8.trim((Slice)Slices.wrappedBuffer((byte[])Bytes.concat((byte[][])new byte[][]{whitespace, sequence, whitespace})), (int[])WHITESPACE_CODE_POINTS), (Object)Slices.wrappedBuffer((byte[])sequence));
            Assert.assertEquals((Object)SliceUtf8.trim((Slice)Slices.wrappedBuffer((byte[])Bytes.concat((byte[][])new byte[][]{whitespace, {13, 10, 9, 32}, whitespace, sequence, whitespace, {13, 10, 9, 32}, whitespace}))), (Object)Slices.wrappedBuffer((byte[])sequence));
            Assert.assertEquals((Object)SliceUtf8.trim((Slice)Slices.wrappedBuffer((byte[])Bytes.concat((byte[][])new byte[][]{whitespace, {13, 10, 9, 32}, whitespace, sequence, whitespace, {13, 10, 9, 32}, whitespace})), (int[])WHITESPACE_CODE_POINTS), (Object)Slices.wrappedBuffer((byte[])sequence));
        }
    }

    @Test
    public void testInvalidUtf8() {
        Assert.assertEquals((int)SliceUtf8.countCodePoints((Slice)Slices.wrappedBuffer((byte[])INVALID_UTF8_1)), (int)0);
        Assert.assertEquals((int)SliceUtf8.countCodePoints((Slice)Slices.wrappedBuffer((byte[])INVALID_UTF8_2)), (int)3);
        Assert.assertEquals((int)SliceUtf8.offsetOfCodePoint((Slice)Slices.wrappedBuffer((byte[])INVALID_UTF8_1), (int)0), (int)0);
        Assert.assertEquals((int)SliceUtf8.offsetOfCodePoint((Slice)Slices.wrappedBuffer((byte[])INVALID_UTF8_1), (int)1), (int)-1);
        Assert.assertEquals((int)SliceUtf8.offsetOfCodePoint((Slice)Slices.wrappedBuffer((byte[])INVALID_UTF8_2), (int)0), (int)0);
        Assert.assertEquals((int)SliceUtf8.offsetOfCodePoint((Slice)Slices.wrappedBuffer((byte[])INVALID_UTF8_2), (int)1), (int)2);
        Assert.assertEquals((int)SliceUtf8.offsetOfCodePoint((Slice)Slices.wrappedBuffer((byte[])INVALID_UTF8_2), (int)2), (int)3);
        Assert.assertEquals((int)SliceUtf8.offsetOfCodePoint((Slice)Slices.wrappedBuffer((byte[])INVALID_UTF8_2), (int)3), (int)-1);
    }

    @Test
    public void testLengthOfCodePoint() {
        Assert.assertEquals((int)SliceUtf8.lengthOfCodePointFromStartByte((byte)127), (int)1);
        Assert.assertEquals((int)SliceUtf8.lengthOfCodePointFromStartByte((byte)-33), (int)2);
        Assert.assertEquals((int)SliceUtf8.lengthOfCodePointFromStartByte((byte)-17), (int)3);
        Assert.assertEquals((int)SliceUtf8.lengthOfCodePointFromStartByte((byte)-9), (int)4);
        for (int codePoint : ALL_CODE_POINTS) {
            String string = new String(new int[]{codePoint}, 0, 1);
            Assert.assertEquals((long)string.codePoints().count(), (long)1L);
            Slice utf8 = Slices.wrappedBuffer((byte[])string.getBytes(StandardCharsets.UTF_8));
            Assert.assertEquals((int)SliceUtf8.lengthOfCodePoint((int)codePoint), (int)utf8.length());
            Assert.assertEquals((int)SliceUtf8.lengthOfCodePoint((Slice)utf8, (int)0), (int)utf8.length());
            Assert.assertEquals((int)SliceUtf8.lengthOfCodePointSafe((Slice)utf8, (int)0), (int)utf8.length());
            Assert.assertEquals((int)SliceUtf8.lengthOfCodePointFromStartByte((byte)utf8.getByte(0)), (int)utf8.length());
            Assert.assertEquals((int)SliceUtf8.getCodePointAt((Slice)utf8, (int)0), (int)codePoint);
            Assert.assertEquals((int)SliceUtf8.getCodePointBefore((Slice)utf8, (int)utf8.length()), (int)codePoint);
            Assert.assertEquals((Object)SliceUtf8.codePointToUtf8((int)codePoint), (Object)utf8);
        }
        Object object = INVALID_SEQUENCES.iterator();
        while (object.hasNext()) {
            byte[] sequence = (byte[])object.next();
            Assert.assertEquals((int)SliceUtf8.lengthOfCodePointSafe((Slice)Slices.wrappedBuffer((byte[])sequence), (int)0), (int)sequence.length);
            Assert.assertEquals((int)SliceUtf8.lengthOfCodePointSafe((Slice)Slices.wrappedBuffer((byte[])Bytes.concat((byte[][])new byte[][]{{120}, sequence})), (int)1), (int)sequence.length);
            Assert.assertEquals((int)SliceUtf8.lengthOfCodePointSafe((Slice)Slices.wrappedBuffer((byte[])Bytes.concat((byte[][])new byte[][]{sequence, {120}})), (int)0), (int)sequence.length);
        }
    }

    @Test(expectedExceptions={InvalidCodePointException.class}, expectedExceptionsMessageRegExp="Invalid code point 0xFFFFFFFF")
    public void testLengthOfNegativeCodePoint() {
        SliceUtf8.lengthOfCodePoint((int)-1);
    }

    @Test(expectedExceptions={InvalidCodePointException.class}, expectedExceptionsMessageRegExp="Invalid code point 0x110000")
    public void testLengthOfOutOfRangeCodePoint() {
        SliceUtf8.lengthOfCodePoint((int)0x110000);
    }

    @Test(expectedExceptions={InvalidUtf8Exception.class}, expectedExceptionsMessageRegExp="Illegal start 0xBF of code point")
    public void testLengthOfCodePointContinuationByte() {
        SliceUtf8.lengthOfCodePointFromStartByte((byte)-65);
    }

    @Test(expectedExceptions={InvalidUtf8Exception.class}, expectedExceptionsMessageRegExp="Illegal start 0xFB of code point")
    public void testLengthOfCodePoint5ByteSequence() {
        SliceUtf8.lengthOfCodePointFromStartByte((byte)-5);
    }

    @Test(expectedExceptions={InvalidUtf8Exception.class}, expectedExceptionsMessageRegExp="Illegal start 0xFD of code point")
    public void testLengthOfCodePoint6ByteByte() {
        SliceUtf8.lengthOfCodePointFromStartByte((byte)-3);
    }

    @Test(expectedExceptions={InvalidUtf8Exception.class}, expectedExceptionsMessageRegExp="Illegal start 0xFE of code point")
    public void testLengthOfCodePointFEByte() {
        SliceUtf8.lengthOfCodePointFromStartByte((byte)-2);
    }

    @Test(expectedExceptions={InvalidUtf8Exception.class}, expectedExceptionsMessageRegExp="Illegal start 0xFF of code point")
    public void testLengthOfCodePointFFByte() {
        SliceUtf8.lengthOfCodePointFromStartByte((byte)-1);
    }

    @Test(expectedExceptions={InvalidUtf8Exception.class}, expectedExceptionsMessageRegExp="UTF-8 sequence truncated")
    public void testCodePointAtTruncated2() {
        SliceUtf8.getCodePointAt((Slice)Slices.wrappedBuffer((byte[])new byte[]{120, -33}), (int)1);
    }

    @Test(expectedExceptions={InvalidUtf8Exception.class}, expectedExceptionsMessageRegExp="UTF-8 sequence truncated")
    public void testCodePointAtTruncated3() {
        SliceUtf8.getCodePointAt((Slice)Slices.wrappedBuffer((byte[])new byte[]{120, -17, -65}), (int)1);
    }

    @Test(expectedExceptions={InvalidUtf8Exception.class}, expectedExceptionsMessageRegExp="UTF-8 sequence truncated")
    public void testCodePointAtTruncated4() {
        SliceUtf8.getCodePointAt((Slice)Slices.wrappedBuffer((byte[])new byte[]{120, -9, -65, -65}), (int)1);
    }

    @Test(expectedExceptions={InvalidUtf8Exception.class}, expectedExceptionsMessageRegExp="Illegal start 0xFB of code point")
    public void testCodePointAt5ByteSequence() {
        SliceUtf8.getCodePointAt((Slice)Slices.wrappedBuffer((byte[])new byte[]{120, -5, -65, -65, -65, -65}), (int)1);
    }

    @Test(expectedExceptions={InvalidUtf8Exception.class}, expectedExceptionsMessageRegExp="UTF-8 is not well formed")
    public void testCodePointBefore5ByteSequence() {
        SliceUtf8.getCodePointBefore((Slice)Slices.wrappedBuffer((byte[])new byte[]{120, -5, -65, -65, -65, -65}), (int)6);
    }

    @Test(expectedExceptions={InvalidCodePointException.class}, expectedExceptionsMessageRegExp="Invalid code point 0xFFFFFFFF")
    public void testSetNegativeCodePoint() {
        SliceUtf8.setCodePointAt((int)-1, (Slice)Slices.allocate((int)8), (int)0);
    }

    @Test(expectedExceptions={InvalidCodePointException.class}, expectedExceptionsMessageRegExp="Invalid code point 0xD800")
    public void testSetSurrogateCodePoint() {
        SliceUtf8.setCodePointAt((int)55296, (Slice)Slices.allocate((int)8), (int)0);
    }

    @Test(expectedExceptions={InvalidCodePointException.class}, expectedExceptionsMessageRegExp="Invalid code point 0x110000")
    public void testSetOutOfRangeCodePoint() {
        SliceUtf8.setCodePointAt((int)0x110000, (Slice)Slices.allocate((int)8), (int)0);
    }

    @Test(expectedExceptions={InvalidCodePointException.class}, expectedExceptionsMessageRegExp="Invalid code point 0xFFFFFFBF")
    public void testSetCodePointContinuationByte() {
        SliceUtf8.setCodePointAt((int)-65, (Slice)Slices.allocate((int)8), (int)0);
    }

    static {
        Collections.shuffle(Arrays.asList(new int[][]{ALL_CODE_POINTS_RANDOM}));
        STRING_ALL_CODE_POINTS_RANDOM = new String(ALL_CODE_POINTS_RANDOM, 0, ALL_CODE_POINTS_RANDOM.length);
        ImmutableList.Builder invalidSequences = ImmutableList.builder();
        invalidSequences.add((Object)new byte[]{-65});
        invalidSequences.add((Object)new byte[]{-33});
        invalidSequences.add((Object)new byte[]{-17});
        invalidSequences.add((Object)new byte[]{-17, -65});
        invalidSequences.add((Object)new byte[]{-9});
        invalidSequences.add((Object)new byte[]{-9, -65});
        invalidSequences.add((Object)new byte[]{-9, -65, -65});
        invalidSequences.add((Object)new byte[]{-9, -65, -65, -65});
        invalidSequences.add((Object)new byte[]{-5});
        invalidSequences.add((Object)new byte[]{-5, -65});
        invalidSequences.add((Object)new byte[]{-5, -65, -65});
        invalidSequences.add((Object)new byte[]{-5, -65, -65, -65});
        invalidSequences.add((Object)new byte[]{-5, -65, -65, -65, -65});
        invalidSequences.add((Object)new byte[]{-3});
        invalidSequences.add((Object)new byte[]{-3, -65});
        invalidSequences.add((Object)new byte[]{-3, -65, -65});
        invalidSequences.add((Object)new byte[]{-3, -65, -65, -65});
        invalidSequences.add((Object)new byte[]{-3, -65, -65, -65, -65});
        invalidSequences.add((Object)new byte[]{-3, -65, -65, -65, -65, -65});
        invalidSequences.add((Object)new byte[]{-1});
        invalidSequences.add((Object)new byte[]{-19, -96, -128});
        invalidSequences.add((Object)new byte[]{-19, -65, -65});
        invalidSequences.add((Object)new byte[]{-64, -81});
        invalidSequences.add((Object)new byte[]{-63, -65});
        invalidSequences.add((Object)new byte[]{-32, -127, -65});
        invalidSequences.add((Object)new byte[]{-32, -112, -128});
        invalidSequences.add((Object)new byte[]{-32, -97, -65});
        invalidSequences.add((Object)new byte[]{-16, -115, -96, -128});
        invalidSequences.add((Object)new byte[]{-16, -115, -65, -65});
        invalidSequences.add((Object)new byte[]{-16, -113, -65, -65});
        INVALID_SEQUENCES = invalidSequences.build();
        INVALID_SEQUENCE_TO_LOWER_EXPANDS = new byte[]{-56, -70, -1};
        INVALID_UTF8_1 = new byte[]{-127};
        INVALID_UTF8_2 = new byte[]{50, -127, 52, 50};
        EM_SPACE_SURROUNDED_BY_CONTINUATION_BYTE = new byte[]{-65, -30, -128, -125, -65};
    }
}

